/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shell.kernel.apps;

import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.regex.Pattern;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.index.Index;
import org.neo4j.graphdb.index.IndexHits;
import org.neo4j.graphdb.index.IndexManager;
import org.neo4j.graphdb.index.RelationshipIndex;
import org.neo4j.shell.AppCommandParser;
import org.neo4j.shell.Continuation;
import org.neo4j.shell.OptionDefinition;
import org.neo4j.shell.OptionValueType;
import org.neo4j.shell.Output;
import org.neo4j.shell.Session;
import org.neo4j.shell.ShellException;
import org.neo4j.shell.kernel.apps.NodeOrRelationship;
import org.neo4j.shell.kernel.apps.TransactionProvidingApp;
import org.neo4j.shell.util.json.JSONException;
import org.neo4j.shell.util.json.JSONObject;

public class IndexProviderShellApp
extends TransactionProvidingApp {
    public IndexProviderShellApp() {
        this.addOptionDefinition("g", new OptionDefinition(OptionValueType.NONE, "Get entities for the given key and value"));
        this.addOptionDefinition("q", new OptionDefinition(OptionValueType.NONE, "Get entities for the given query"));
        this.addOptionDefinition("i", new OptionDefinition(OptionValueType.NONE, "Index the current entity with a key and (optionally) value. If no value is given the property value for the key is used"));
        this.addOptionDefinition("r", new OptionDefinition(OptionValueType.NONE, "Removes a key-value pair for the current entity from the index. Key and value are optional"));
        this.addOptionDefinition("c", OPTION_DEF_FOR_C);
        this.addOptionDefinition("cd", new OptionDefinition(OptionValueType.NONE, "Does a 'cd' command to the returned node. Could also be done using the -c option. (Implies -g)"));
        this.addOptionDefinition("ls", new OptionDefinition(OptionValueType.NONE, "Does a 'ls' command on the returned entities. Could also be done using the -c option. (Implies -g)"));
        this.addOptionDefinition("create", new OptionDefinition(OptionValueType.NONE, "Creates a new index with a set of configuration parameters"));
        this.addOptionDefinition("get-config", new OptionDefinition(OptionValueType.NONE, "Displays the configuration for an index"));
        this.addOptionDefinition("set-config", new OptionDefinition(OptionValueType.NONE, "EXPERT, USE WITH CARE: Set one configuration parameter for an index (remove if no value)"));
        this.addOptionDefinition("t", new OptionDefinition(OptionValueType.MUST, "The type of index, either Node or Relationship"));
        this.addOptionDefinition("indexes", new OptionDefinition(OptionValueType.NONE, "Lists all index names"));
        this.addOptionDefinition("delete", new OptionDefinition(OptionValueType.NONE, "Deletes an index"));
    }

    @Override
    public String getName() {
        return "index";
    }

    @Override
    public String getDescription() {
        return "Access the legacy indexes for your Neo4j graph database. Use -g for getting nodes, -i and -r to manipulate.\nExamples:\n$ index -i persons name  (will index property 'name' with its value for current node in the 'persons' index)\n$ index -g persons name \"Thomas A. Anderson\"  (will get nodes matching that name from the 'persons' index)\n$ index -q persons \"name:'Thomas*'\"  (will get nodes with names that start with Thomas)\n$ index --cd persons name \"Agent Smith\"  (will 'cd' to the 'Agent Smith' node from the 'persons' index).\n\nEXPERT, USE WITH CARE. NOTE THAT INDEX DATA MAY BECOME INVALID AFTER CONFIGURATION CHANGES:\n$ index --set-config accounts type fulltext  (will set parameter 'type'='fulltext' for 'accounts' index).\n$ index --set-config accounts to_lower_case  (will remove parameter 'to_lower_case' from 'accounts' index).\n$ index -t Relationship --delete friends  (will delete the 'friends' relationship index).";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Continuation exec(AppCommandParser parser, Session session, Output out) throws ShellException, RemoteException {
        boolean indexes;
        boolean delete2;
        boolean setConfig;
        boolean create;
        boolean getConfig;
        boolean remove2;
        boolean index;
        boolean doCd = parser.options().containsKey("cd");
        boolean doLs = parser.options().containsKey("ls");
        boolean query = parser.options().containsKey("q");
        boolean get2 = parser.options().containsKey("g") || query || doCd || doLs;
        int count2 = this.boolCount(get2, index = parser.options().containsKey("i"), remove2 = parser.options().containsKey("r"), getConfig = parser.options().containsKey("get-config"), create = parser.options().containsKey("create"), setConfig = parser.options().containsKey("set-config"), delete2 = parser.options().containsKey("delete"), indexes = parser.options().containsKey("indexes"));
        if (count2 != 1) {
            throw new ShellException("Supply one of: -g, -i, -r, --get-config, --set-config, --create, --delete, --indexes");
        }
        if (get2) {
            String commandToRun = parser.options().get("c");
            ArrayList<String> commandsToRun = new ArrayList<String>();
            boolean specialCommand = false;
            if (doCd || doLs) {
                specialCommand = true;
                if (doCd) {
                    commandsToRun.add("cd -a $i");
                } else if (doLs) {
                    commandsToRun.add("ls $i");
                }
            } else if (commandToRun != null) {
                commandsToRun.addAll(Arrays.asList(commandToRun.split(Pattern.quote("&&"))));
            }
            if (this.getIndex(this.getIndexName(parser), this.getEntityType(parser), out) == null) {
                return Continuation.INPUT_COMPLETE;
            }
            try (IndexHits<PropertyContainer> result2 = query ? this.query(parser, out) : this.get(parser, out);){
                for (PropertyContainer hit : result2) {
                    IndexProviderShellApp.printAndInterpretTemplateLines(commandsToRun, false, !specialCommand, NodeOrRelationship.wrap(hit), this.getServer(), session, out);
                }
            }
        } else if (index) {
            this.index(parser, session, out);
        } else if (remove2) {
            if (this.getIndex(this.getIndexName(parser), Node.class, out) == null) {
                return null;
            }
            this.remove(parser, session, out);
        } else if (getConfig) {
            this.displayConfig(parser, out);
        } else if (create) {
            this.createIndex(parser, out);
        } else if (setConfig) {
            this.setConfig(parser, out);
        } else if (delete2) {
            this.deleteIndex(parser, out);
        }
        if (indexes) {
            this.listIndexes(out);
        }
        return Continuation.INPUT_COMPLETE;
    }

    private String getIndexName(AppCommandParser parser) throws ShellException {
        return parser.argument(0, "Index name not supplied");
    }

    private void listIndexes(Output out) throws RemoteException {
        out.println((Serializable)((Object)"Node indexes:"));
        for (String name2 : this.getServer().getDb().index().nodeIndexNames()) {
            out.println((Serializable)((Object)("  " + name2)));
        }
        out.println((Serializable)((Object)""));
        out.println((Serializable)((Object)"Relationship indexes:"));
        for (String name2 : this.getServer().getDb().index().relationshipIndexNames()) {
            out.println((Serializable)((Object)("  " + name2)));
        }
    }

    private void deleteIndex(AppCommandParser parser, Output out) throws RemoteException, ShellException {
        Index<? extends PropertyContainer> index = this.getIndex(this.getIndexName(parser), this.getEntityType(parser), out);
        if (index != null) {
            index.delete();
        }
    }

    private void setConfig(AppCommandParser parser, Output out) throws ShellException, RemoteException {
        String indexName = this.getIndexName(parser);
        String key = parser.argument(1, "Key not supplied");
        String value = parser.arguments().size() > 2 ? parser.arguments().get(2) : null;
        Class<? extends PropertyContainer> entityType = this.getEntityType(parser);
        Index<? extends PropertyContainer> index = this.getIndex(indexName, entityType, out);
        if (index == null) {
            return;
        }
        String oldValue = value != null ? this.getServer().getDb().index().setConfiguration(index, key, value) : this.getServer().getDb().index().removeConfiguration(index, key);
        this.printWarning(out);
    }

    private void printWarning(Output out) throws RemoteException {
        out.println((Serializable)((Object)"INDEX CONFIGURATION CHANGED, INDEX DATA MAY BE INVALID"));
    }

    private void createIndex(AppCommandParser parser, Output out) throws RemoteException, ShellException {
        Map<String, Object> config;
        Class<? extends PropertyContainer> entityType;
        String indexName = this.getIndexName(parser);
        if (this.getIndex(indexName, entityType = this.getEntityType(parser), null) != null) {
            out.println((Serializable)((Object)(entityType.getClass().getSimpleName() + " index '" + indexName + "' already exists")));
            return;
        }
        try {
            config = parser.arguments().size() >= 2 ? IndexProviderShellApp.parseJSONMap(parser.arguments().get(1)) : null;
        }
        catch (JSONException e) {
            throw ShellException.wrapCause(e);
        }
        if (entityType.equals(Node.class)) {
            Index<Node> index = config != null ? this.getServer().getDb().index().forNodes(indexName, config) : this.getServer().getDb().index().forNodes(indexName);
        } else {
            RelationshipIndex relationshipIndex = config != null ? this.getServer().getDb().index().forRelationships(indexName, config) : this.getServer().getDb().index().forRelationships(indexName);
        }
    }

    private <T extends PropertyContainer> Index<T> getIndex(String indexName, Class<T> type, Output out) throws RemoteException {
        boolean exists2;
        IndexManager index = this.getServer().getDb().index();
        boolean bl = exists2 = type.equals(Node.class) && index.existsForNodes(indexName) || type.equals(Relationship.class) && index.existsForRelationships(indexName);
        if (!exists2) {
            if (out != null) {
                out.println((Serializable)((Object)("No such " + type.getSimpleName().toLowerCase() + " index '" + indexName + "'")));
            }
            return null;
        }
        return type.equals(Node.class) ? index.forNodes(indexName) : index.forRelationships(indexName);
    }

    private void displayConfig(AppCommandParser parser, Output out) throws RemoteException, ShellException {
        String indexName = this.getIndexName(parser);
        Index<? extends PropertyContainer> index = this.getIndex(indexName, this.getEntityType(parser), out);
        if (index == null) {
            return;
        }
        try {
            out.println((Serializable)((Object)new JSONObject(this.getServer().getDb().index().getConfiguration(index)).toString(4)));
        }
        catch (JSONException e) {
            throw ShellException.wrapCause(e);
        }
    }

    private Class<? extends PropertyContainer> getEntityType(AppCommandParser parser) throws ShellException {
        String type = parser.options().get("t");
        String string2 = type = type != null ? type.toLowerCase() : null;
        if (type == null || type.equals("node")) {
            return Node.class;
        }
        if (type.equals("relationship")) {
            return Relationship.class;
        }
        throw new ShellException("'type' expects one of [Node, Relationship]");
    }

    private int boolCount(boolean ... bools) {
        int count2 = 0;
        for (boolean bool : bools) {
            if (!bool) continue;
            ++count2;
        }
        return count2;
    }

    private IndexHits<PropertyContainer> get(AppCommandParser parser, Output out) throws ShellException, RemoteException {
        String index = this.getIndexName(parser);
        String key = parser.argument(1, "Key not supplied");
        String value = parser.argument(2, "Value not supplied");
        Index<? extends PropertyContainer> theIndex = this.getIndex(index, this.getEntityType(parser), out);
        return theIndex.get(key, value);
    }

    private IndexHits<PropertyContainer> query(AppCommandParser parser, Output out) throws RemoteException, ShellException {
        String index = this.getIndexName(parser);
        String query1 = parser.argument(1, "Key not supplied");
        String query2 = parser.argumentWithDefault(2, null);
        Index<? extends PropertyContainer> theIndex = this.getIndex(index, this.getEntityType(parser), out);
        return query2 != null ? theIndex.query(query1, query2) : theIndex.query(query1);
    }

    private void index(AppCommandParser parser, Session session, Output out) throws ShellException, RemoteException {
        Object value;
        NodeOrRelationship current = this.getCurrent(session);
        String index = this.getIndexName(parser);
        String key = parser.argument(1, "Key not supplied");
        Object object = value = parser.arguments().size() > 2 ? parser.arguments().get(2) : current.getProperty(key, null);
        if (value == null) {
            throw new ShellException("No value to index");
        }
        RelationshipIndex theIndex = current.isNode() ? this.getServer().getDb().index().forNodes(index) : this.getServer().getDb().index().forRelationships(index);
        theIndex.add(current.asPropertyContainer(), key, value);
    }

    private void remove(AppCommandParser parser, Session session, Output out) throws ShellException, RemoteException {
        Index<PropertyContainer> theIndex;
        NodeOrRelationship current = this.getCurrent(session);
        String index = this.getIndexName(parser);
        String key = parser.argumentWithDefault(1, null);
        String value = null;
        if (key != null) {
            value = parser.argumentWithDefault(2, null);
        }
        if ((theIndex = current.isNode() ? this.getIndex(index, Node.class, out) : this.getIndex(index, Relationship.class, out)) != null) {
            if (key != null && value != null) {
                theIndex.remove(current.asPropertyContainer(), key, value);
            } else if (key != null) {
                theIndex.remove(current.asPropertyContainer(), key);
            } else {
                theIndex.remove((Node)current.asPropertyContainer());
            }
        }
    }
}

