/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shell.kernel.apps;

import java.io.Serializable;
import java.rmi.RemoteException;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.impl.core.ThreadToStatementContextBridge;
import org.neo4j.shell.AppCommandParser;
import org.neo4j.shell.Continuation;
import org.neo4j.shell.Output;
import org.neo4j.shell.Session;
import org.neo4j.shell.ShellException;
import org.neo4j.shell.kernel.GraphDatabaseShellServer;
import org.neo4j.shell.kernel.apps.NonTransactionProvidingApp;

public class Begin
extends NonTransactionProvidingApp {
    private static String TRANSACTION = "TRANSACTION";

    @Override
    public String getDescription() {
        return "Opens a transaction";
    }

    @Override
    protected Continuation exec(AppCommandParser parser, Session session, Output out) throws ShellException, RemoteException {
        int count2;
        String lineWithoutApp = parser.getLineWithoutApp();
        if (!this.acceptableText(lineWithoutApp)) {
            out.println((Serializable)((Object)"Error: To open a transaction, write BEGIN TRANSACTION"));
            return Continuation.INPUT_COMPLETE;
        }
        KernelTransaction tx = Begin.currentTransaction(this.getServer());
        this.getServer().getDb().beginTx();
        Integer txCount = session.getCommitCount();
        if (txCount == null) {
            if (tx == null) {
                count2 = 0;
                out.println((Serializable)((Object)"Transaction started"));
            } else {
                count2 = 1;
                out.println((Serializable)((Object)"Warning: transaction found that was not started by the shell."));
            }
        } else {
            count2 = txCount;
            out.println((Serializable)((Object)String.format("Nested transaction started (Tx count: %d)", count2 + 1)));
        }
        session.setCommitCount(++count2);
        return Continuation.INPUT_COMPLETE;
    }

    private boolean acceptableText(String line) {
        if (line == null || line.length() > TRANSACTION.length()) {
            return false;
        }
        String substring = TRANSACTION.substring(0, line.length());
        return substring.equals(line.toUpperCase());
    }

    public static KernelTransaction currentTransaction(GraphDatabaseShellServer server) {
        return server.getDb().getDependencyResolver().resolveDependency(ThreadToStatementContextBridge.class).getTopLevelTransactionBoundToThisThread(false);
    }
}

