/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shell.impl;

import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.neo4j.shell.Session;
import org.neo4j.shell.ShellException;
import org.neo4j.shell.ShellServer;
import org.neo4j.shell.TabCompletion;
import org.neo4j.shell.Welcome;
import org.neo4j.shell.impl.BashVariableInterpreter;
import org.neo4j.shell.impl.RemotelyAvailableServer;

public abstract class SimpleAppServer
implements ShellServer {
    private ShellServer remoteEndPoint;
    protected final BashVariableInterpreter bashInterpreter = new BashVariableInterpreter();
    public static final String DEFAULT_NAME = "shell";
    public static final int DEFAULT_PORT = 1337;
    private final Map<Serializable, Session> clientSessions = new ConcurrentHashMap<Serializable, Session>();
    private final AtomicInteger nextClientId = new AtomicInteger();

    @Override
    public String getName() {
        return DEFAULT_NAME;
    }

    @Override
    public Serializable interpretVariable(Serializable clientID, String key) throws ShellException, RemoteException {
        return (Serializable)this.getClientSession(clientID).get(key);
    }

    protected Serializable newClientId() {
        return Integer.valueOf(this.nextClientId.incrementAndGet());
    }

    @Override
    public Welcome welcome(Map<String, Serializable> initialSession) throws RemoteException, ShellException {
        Serializable clientId = this.newClientId();
        if (this.clientSessions.containsKey(clientId)) {
            throw new IllegalStateException("Client " + clientId + " already initialized");
        }
        Session session = this.newSession(clientId, initialSession);
        this.clientSessions.put(clientId, session);
        try {
            String message = this.noWelcome(initialSession) ? "" : this.getWelcomeMessage();
            return new Welcome(message, clientId, this.getPrompt(session));
        }
        catch (ShellException e) {
            throw new RemoteException(e.getMessage());
        }
    }

    private boolean noWelcome(Map<String, Serializable> initialSession) {
        Serializable quiet = initialSession.get("quiet");
        if (quiet == null) {
            return false;
        }
        if (quiet instanceof Boolean) {
            return (Boolean)quiet;
        }
        return quiet.toString().equalsIgnoreCase("true");
    }

    private Session newSession(Serializable id, Map<String, Serializable> initialSession) throws ShellException {
        Session session = new Session(id);
        this.initialPopulateSession(session);
        for (Map.Entry<String, Serializable> entry : initialSession.entrySet()) {
            session.set(entry.getKey(), entry.getValue());
        }
        return session;
    }

    protected void initialPopulateSession(Session session) throws ShellException {
    }

    protected abstract String getPrompt(Session var1) throws ShellException;

    protected String getDefaultPrompt() {
        return "sh$ ";
    }

    protected String getWelcomeMessage() {
        return "Welcome to the shell";
    }

    public Session getClientSession(Serializable clientID) {
        Session session = this.clientSessions.get(clientID);
        if (session == null) {
            throw new IllegalStateException("Client " + clientID + " not initialized");
        }
        return session;
    }

    @Override
    public void leave(Serializable clientID) throws RemoteException {
        if (this.clientSessions.remove(clientID) == null) {
            throw new IllegalStateException("Client " + clientID + " not initialized");
        }
    }

    @Override
    public synchronized void shutdown() throws RemoteException {
        if (this.remoteEndPoint != null) {
            this.remoteEndPoint.shutdown();
            this.remoteEndPoint = null;
        }
    }

    @Override
    public synchronized void makeRemotelyAvailable(int port, String name2) throws RemoteException {
        this.remoteEndPoint().makeRemotelyAvailable(port, name2);
    }

    @Override
    public synchronized void makeRemotelyAvailable(String host, int port, String name2) throws RemoteException {
        this.remoteEndPoint().makeRemotelyAvailable(host, port, name2);
    }

    private ShellServer remoteEndPoint() throws RemoteException {
        if (this.remoteEndPoint == null) {
            this.remoteEndPoint = new RemotelyAvailableServer(this);
        }
        return this.remoteEndPoint;
    }

    @Override
    public String[] getAllAvailableCommands() {
        return new String[0];
    }

    public TabCompletion tabComplete(String partOfLine, Session session) {
        return new TabCompletion(Collections.emptyList(), 0);
    }

    @Override
    public void setSessionVariable(Serializable clientID, String key, Object value) throws ShellException {
        this.getClientSession(clientID).set(key, value);
    }
}

