/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shell.impl;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.neo4j.shell.Output;
import org.neo4j.shell.impl.RemoteOutput;

public class CollectingOutput
extends UnicastRemoteObject
implements Output,
Serializable,
Iterable<String> {
    private static final long serialVersionUID = 1L;
    private transient StringWriter stringWriter = new StringWriter();
    private transient PrintWriter allLinesAsOne = new PrintWriter(this.stringWriter);
    private List<String> lines = new ArrayList<String>();
    private String ongoingLine = "";

    @Override
    public Appendable append(CharSequence csq, int start, int end) throws IOException {
        this.print((Serializable)((Object)RemoteOutput.asString(csq).substring(start, end)));
        return this;
    }

    @Override
    public Appendable append(char c) throws IOException {
        this.print(Character.valueOf(c));
        return this;
    }

    @Override
    public Appendable append(CharSequence csq) throws IOException {
        this.print((Serializable)((Object)RemoteOutput.asString(csq)));
        return this;
    }

    @Override
    public void println(Serializable object) throws RemoteException {
        this.print(object);
        this.println();
    }

    @Override
    public void println() throws RemoteException {
        this.lines.add(this.ongoingLine);
        this.allLinesAsOne.println(this.ongoingLine);
        this.ongoingLine = "";
    }

    @Override
    public void print(Serializable object) throws RemoteException {
        String string2 = object.toString();
        int index = 0;
        while (true) {
            if ((index = string2.indexOf(System.lineSeparator(), index)) < 0) break;
            String part = string2.substring(0, index);
            this.ongoingLine = this.ongoingLine + part;
            this.println();
            string2 = string2.substring(index + System.lineSeparator().length(), string2.length());
        }
        this.ongoingLine = this.ongoingLine + string2;
    }

    @Override
    public Iterator<String> iterator() {
        return this.lines.iterator();
    }

    public String asString() {
        try {
            this.allLinesAsOne.flush();
            this.stringWriter.flush();
            String string2 = this.stringWriter.getBuffer().toString();
            return string2;
        }
        finally {
            this.clear();
        }
    }

    private void clear() {
        this.lines.clear();
        this.ongoingLine = "";
        this.stringWriter = new StringWriter();
        this.allLinesAsOne = new PrintWriter(this.stringWriter);
    }
}

