/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shell.impl;

import java.rmi.RemoteException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.neo4j.kernel.internal.Version;
import org.neo4j.shell.Session;
import org.neo4j.shell.ShellException;
import org.neo4j.shell.ShellServer;

public class BashVariableInterpreter {
    private static final Map<String, Replacer> STATIC_REPLACERS = new HashMap<String, Replacer>();
    private final Map<String, Replacer> localReplacers = new HashMap<String, Replacer>();

    public void addReplacer(String key, Replacer replacer) {
        this.localReplacers.put(key, replacer);
    }

    public String interpret(String string2, ShellServer server, Session session) throws ShellException {
        string2 = this.replace(string2, server, session, this.localReplacers);
        string2 = this.replace(string2, server, session, STATIC_REPLACERS);
        return string2;
    }

    private String replace(String string2, ShellServer server, Session session, Map<String, Replacer> replacers) throws ShellException {
        for (Map.Entry<String, Replacer> replacer : replacers.entrySet()) {
            String value = replacer.getValue().getReplacement(server, session);
            string2 = string2.replaceAll("\\\\" + replacer.getKey(), value);
        }
        return string2;
    }

    static {
        STATIC_REPLACERS.put("d", new DateReplacer("EEE MMM dd"));
        STATIC_REPLACERS.put("h", new HostReplacer());
        STATIC_REPLACERS.put("H", new HostReplacer());
        STATIC_REPLACERS.put("s", new HostReplacer());
        STATIC_REPLACERS.put("t", new DateReplacer("HH:mm:ss"));
        STATIC_REPLACERS.put("T", new DateReplacer("KK:mm:ss"));
        STATIC_REPLACERS.put("@", new DateReplacer("KK:mm aa"));
        STATIC_REPLACERS.put("A", new DateReplacer("HH:mm"));
        STATIC_REPLACERS.put("u", new StaticReplacer("user"));
        STATIC_REPLACERS.put("v", new StaticReplacer(Version.getKernel().getReleaseVersion()));
        STATIC_REPLACERS.put("V", new StaticReplacer(Version.getKernel().getVersion()));
    }

    public static class HostReplacer
    implements Replacer {
        @Override
        public String getReplacement(ShellServer server, Session session) {
            try {
                return server.getName();
            }
            catch (RemoteException e) {
                return "";
            }
        }
    }

    public static class DateReplacer
    implements Replacer {
        private final DateFormat format;

        public DateReplacer(String format2) {
            this.format = new SimpleDateFormat(format2);
        }

        @Override
        public String getReplacement(ShellServer server, Session session) {
            return this.format.format(new Date());
        }
    }

    public static class StaticReplacer
    implements Replacer {
        private final String value;

        public StaticReplacer(String value) {
            this.value = value;
        }

        @Override
        public String getReplacement(ShellServer server, Session session) {
            return this.value;
        }
    }

    public static interface Replacer {
        public String getReplacement(ShellServer var1, Session var2) throws ShellException;
    }
}

