/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shell.impl;

import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.neo4j.shell.App;
import org.neo4j.shell.AppShellServer;
import org.neo4j.shell.OptionDefinition;
import org.neo4j.shell.Output;
import org.neo4j.shell.Session;
import org.neo4j.shell.ShellException;
import org.neo4j.shell.util.json.JSONArray;
import org.neo4j.shell.util.json.JSONException;
import org.neo4j.shell.util.json.JSONObject;

public abstract class AbstractApp
implements App {
    private final Map<String, OptionDefinition> optionDefinitions = new HashMap<String, OptionDefinition>();
    private AppShellServer server;

    @Override
    public String getName() {
        return this.getClass().getSimpleName().toLowerCase();
    }

    @Override
    public OptionDefinition getOptionDefinition(String option) {
        return this.optionDefinitions.get(option);
    }

    protected void addOptionDefinition(String option, OptionDefinition definition) {
        this.optionDefinitions.put(option, definition);
    }

    @Override
    public String[] getAvailableOptions() {
        Object[] result2 = this.optionDefinitions.keySet().toArray(new String[this.optionDefinitions.size()]);
        Arrays.sort(result2);
        return result2;
    }

    public void setServer(AppShellServer server) {
        if (this.server != null) {
            throw new IllegalStateException("Server already set");
        }
        this.server = server;
    }

    @Override
    public AppShellServer getServer() {
        return this.server;
    }

    @Override
    public String getDescription() {
        return null;
    }

    @Override
    public String getDescription(String option) {
        OptionDefinition definition = this.optionDefinitions.get(option);
        return definition == null ? null : definition.getDescription();
    }

    @Override
    public void shutdown() {
    }

    @Override
    public List<String> completionCandidates(String partOfLine, Session session) throws ShellException {
        return Collections.emptyList();
    }

    protected static Map<String, Object> parseFilter(String filterString, Output out) throws RemoteException, ShellException {
        Map<String, Object> map2;
        if (filterString == null) {
            return new HashMap<String, Object>();
        }
        String signsOfJSON = ":";
        int numberOfSigns = 0;
        for (int i = 0; i < signsOfJSON.length(); ++i) {
            if (!filterString.contains(String.valueOf(signsOfJSON.charAt(i)))) continue;
            ++numberOfSigns;
        }
        if (numberOfSigns >= 1) {
            String jsonString = filterString;
            if (!jsonString.startsWith("{")) {
                jsonString = "{" + jsonString;
            }
            if (!jsonString.endsWith("}")) {
                jsonString = jsonString + "}";
            }
            try {
                map2 = AbstractApp.parseJSONMap(jsonString);
            }
            catch (JSONException e) {
                out.println((Serializable)((Object)("parser: \"" + filterString + "\" hasn't got " + "correct JSON formatting: " + e.getMessage())));
                throw ShellException.wrapCause(e);
            }
        } else {
            map2 = new HashMap<String, Object>();
            map2.put(filterString, null);
        }
        return map2;
    }

    protected static Map<String, Object> parseJSONMap(String jsonString) throws JSONException {
        JSONObject object = new JSONObject(jsonString);
        HashMap<String, Object> result2 = new HashMap<String, Object>();
        for (String name2 : JSONObject.getNames(object)) {
            Object value = object.get(name2);
            if (value != null && value instanceof String && ((String)value).length() == 0) {
                value = null;
            }
            result2.put(name2, value);
        }
        return result2;
    }

    protected static Object[] parseArray(String string2) {
        try {
            JSONArray array = new JSONArray(string2);
            Object[] result2 = new Object[array.length()];
            for (int i = 0; i < result2.length; ++i) {
                result2[i] = array.get(i);
            }
            return result2;
        }
        catch (JSONException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    @Override
    public boolean takesOptions() {
        return !this.optionDefinitions.isEmpty();
    }
}

