/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shell.apps.extra;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import java.lang.reflect.Method;
import java.util.Map;
import org.neo4j.shell.Output;
import org.neo4j.shell.ShellException;
import org.neo4j.shell.apps.extra.ScriptExecutor;

public class JshExecutor
extends ScriptExecutor {
    private static final String INTERPRETER_CLASS = "org.python.util.PythonInterpreter";

    private static String tryFindEnvironmentVariable(String ... examples) {
        Map<String, String> env = System.getenv();
        for (String example : examples) {
            for (String envKey : env.keySet()) {
                if (!envKey.contains(example)) continue;
                return env.get(envKey);
            }
        }
        return null;
    }

    @Override
    protected void ensureDependenciesAreInClasspath() throws ShellException {
        try {
            Class.forName(INTERPRETER_CLASS);
        }
        catch (ClassNotFoundException e) {
            throw new ShellException("Jython not found in the classpath");
        }
    }

    @Override
    protected String getPathKey() {
        return "JSH_PATH";
    }

    @Override
    protected Object newInterpreter(String[] paths) throws ShellException {
        try {
            return Class.forName(INTERPRETER_CLASS).newInstance();
        }
        catch (Exception e) {
            throw new ShellException("Invalid jython classes");
        }
    }

    @Override
    protected void runScript(Object interpreter, String scriptName, Map<String, Object> properties, String[] paths) throws Exception {
        File scriptFile = this.findScriptFile(scriptName, paths);
        Output out = (Output)properties.remove("out");
        interpreter.getClass().getMethod("setOut", Writer.class).invoke(interpreter, new OutputWriter(out));
        Method setMethod = interpreter.getClass().getMethod("set", String.class, Object.class);
        for (String key : properties.keySet()) {
            setMethod.invoke(interpreter, key, properties.get(key));
        }
        interpreter.getClass().getMethod("execfile", String.class).invoke(interpreter, scriptFile.getAbsolutePath());
    }

    private File findScriptFile(String scriptName, String[] paths) throws ShellException {
        for (String path : paths) {
            File result2 = this.findScriptFile(scriptName, path);
            if (result2 == null) continue;
            return result2;
        }
        throw new ShellException("No script '" + scriptName + "' found");
    }

    private File findScriptFile(String scriptName, String path) {
        File pathFile = new File(path);
        if (!pathFile.exists()) {
            return null;
        }
        for (File file : pathFile.listFiles()) {
            String extension2;
            String name2 = file.getName();
            int dotIndex = name2.lastIndexOf(46);
            name2 = dotIndex == -1 ? name2 : name2.substring(0, dotIndex);
            String string2 = extension2 = dotIndex == -1 ? null : file.getName().substring(dotIndex + 1);
            if (!scriptName.equals(name2) || extension2 != null && !extension2.toLowerCase().equals("py")) continue;
            return file;
        }
        return null;
    }

    static {
        String jythonSystemVariableName = "python.home";
        if (System.getProperty(jythonSystemVariableName) == null) {
            String variable = JshExecutor.tryFindEnvironmentVariable("JYTHON_HOME", "JYTHONHOME", "JYTHON", "PYTHON_HOME", "PYTHONHOME", "PYTHON");
            variable = variable == null ? "/usr/local/jython" : variable;
            System.setProperty(jythonSystemVariableName, variable);
        }
    }

    private static class OutputWriter
    extends Writer {
        private Output out;

        OutputWriter(Output out) {
            this.out = out;
        }

        @Override
        public Writer append(char c) throws IOException {
            this.out.append(c);
            return this;
        }

        @Override
        public Writer append(CharSequence csq, int start, int end) throws IOException {
            this.out.append(csq, start, end);
            return this;
        }

        @Override
        public Writer append(CharSequence csq) throws IOException {
            this.out.append(csq);
            return this;
        }

        @Override
        public void close() throws IOException {
        }

        @Override
        public void flush() throws IOException {
        }

        @Override
        public void write(char[] cbuf, int off, int len) throws IOException {
            this.out.print((Serializable)((Object)new String(cbuf, off, len)));
        }

        @Override
        public void write(char[] cbuf) throws IOException {
            this.out.print((Serializable)((Object)new String(cbuf)));
        }

        @Override
        public void write(int c) throws IOException {
            this.out.print((Serializable)((Object)String.valueOf(c)));
        }

        @Override
        public void write(String str2, int off, int len) throws IOException {
            char[] cbuf = new char[len];
            str2.getChars(off, off + len, cbuf, 0);
            this.write(cbuf, off, len);
        }

        @Override
        public void write(String str2) throws IOException {
            this.out.print((Serializable)((Object)str2));
        }
    }
}

