/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shell.apps;

import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import org.neo4j.helpers.Args;
import org.neo4j.shell.App;
import org.neo4j.shell.AppCommandParser;
import org.neo4j.shell.Continuation;
import org.neo4j.shell.OptionDefinition;
import org.neo4j.shell.OptionValueType;
import org.neo4j.shell.Output;
import org.neo4j.shell.Session;
import org.neo4j.shell.ShellException;
import org.neo4j.shell.ShellServer;
import org.neo4j.shell.impl.AbstractApp;
import org.neo4j.shell.impl.AbstractAppServer;

public class Man
extends AbstractApp {
    public static final int CONSOLE_WIDTH = 80;
    private static Collection<String> availableCommands;

    public Man() {
        this.addOptionDefinition("l", new OptionDefinition(OptionValueType.NONE, "Display the commands in a vertical list"));
    }

    @Override
    public Continuation execute(AppCommandParser parser, Session session, Output out) throws Exception {
        if (parser.arguments().size() == 0) {
            boolean list2 = parser.options().containsKey("l");
            Man.printHelpString(out, this.getServer(), list2);
            return Continuation.INPUT_COMPLETE;
        }
        App app = this.getApp(parser);
        out.println((Serializable)((Object)""));
        for (String line : Args.splitLongLine(this.fixDesciption(app.getDescription()), 80)) {
            out.println((Serializable)((Object)line));
        }
        this.println(out, "");
        boolean hasOptions = false;
        for (String option : app.getAvailableOptions()) {
            hasOptions = true;
            String description = this.fixDesciption(app.getDescription(option));
            String[] descriptionLines = Args.splitLongLine(description, 80);
            for (int i = 0; i < descriptionLines.length; ++i) {
                String line = "";
                if (i == 0) {
                    String optionPrefix = option.length() > 1 ? "--" : "-";
                    line = optionPrefix + option;
                }
                line = line + "\t ";
                line = line + descriptionLines[i];
                this.println(out, line);
            }
        }
        if (hasOptions) {
            this.println(out, "");
        }
        return Continuation.INPUT_COMPLETE;
    }

    private static String getShortUsageString() {
        return "man <command>";
    }

    private String fixDesciption(String description) {
        if (description == null) {
            description = "";
        } else if (!description.endsWith(".")) {
            description = description + ".";
        }
        return description;
    }

    private void println(Output out, String string2) throws RemoteException {
        out.println((Serializable)((Object)("  " + string2)));
    }

    private App getApp(AppCommandParser parser) throws Exception {
        String appName = parser.arguments().get(0).toLowerCase();
        App app = this.getServer().findApp(appName);
        if (app == null) {
            throw new ShellException("No manual entry for '" + appName + "'");
        }
        return app;
    }

    @Override
    public String getDescription() {
        return "Display a manual for a command or a general help message.\nUsage: " + Man.getShortUsageString();
    }

    public static void printHelpString(Output out, ShellServer server, boolean list2) throws RemoteException {
        String header = "Available commands:";
        if (list2) {
            out.println((Serializable)((Object)header));
            out.println();
            for (String command : server.getAllAvailableCommands()) {
                out.println((Serializable)((Object)("   " + command)));
            }
            out.println();
        } else {
            out.println((Serializable)((Object)(header + " " + Man.availableCommandsAsString(server))));
        }
        out.println((Serializable)((Object)("Use " + Man.getShortUsageString() + " for info about each command.")));
    }

    public static synchronized Collection<String> getAvailableCommands(ShellServer server) {
        if (availableCommands == null) {
            ArrayList<String> list2 = new ArrayList<String>();
            for (String name2 : ((AbstractAppServer)server).getAllAvailableCommands()) {
                list2.add(name2);
            }
            availableCommands = list2;
        }
        return availableCommands;
    }

    private static synchronized String availableCommandsAsString(ShellServer server) {
        StringBuffer commands = new StringBuffer();
        for (String command : Man.getAvailableCommands(server)) {
            if (commands.length() > 0) {
                commands.append(" ");
            }
            commands.append(command);
        }
        return commands.toString();
    }
}

