/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shell;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

public class TextUtil {
    public static String templateString(String templateString, Map<String, ? extends Object> data) {
        return TextUtil.templateString(templateString, "\\$", data);
    }

    public static String templateString(String templateString, String variablePrefix, Map<String, ? extends Object> data) {
        HashMap lengthMap = new HashMap();
        int longest = 0;
        for (String key : data.keySet()) {
            int length2 = key.length();
            if (length2 > longest) {
                longest = length2;
            }
            List<String> innerList = null;
            Integer innerKey = length2;
            if (lengthMap.containsKey(innerKey)) {
                innerList = (List)lengthMap.get(innerKey);
            } else {
                innerList = new ArrayList();
                lengthMap.put(innerKey, innerList);
            }
            innerList.add(key);
        }
        String result2 = templateString;
        for (int i = longest; i >= 0; --i) {
            Integer lengthKey = i;
            if (!lengthMap.containsKey(lengthKey)) continue;
            List list2 = (List)lengthMap.get(lengthKey);
            for (String key : list2) {
                Object value = data.get(key);
                if (value == null) continue;
                String replacement = data.get(key).toString();
                String regExpMatchString = variablePrefix + key;
                result2 = result2.replaceAll(regExpMatchString, replacement);
            }
        }
        return result2;
    }

    public static String lastWordOrQuoteOf(String text2, boolean preserveQuotation) {
        String[] quoteParts = text2.split("\"");
        String lastPart = quoteParts[quoteParts.length - 1];
        boolean isWithinQuotes = quoteParts.length % 2 == 0;
        String lastWord = null;
        if (isWithinQuotes) {
            lastWord = lastPart;
            if (preserveQuotation) {
                lastWord = "\"" + lastWord + (text2.endsWith("\"") ? "\"" : "");
            }
        } else {
            String[] lastPartParts = TextUtil.splitAndKeepEscapedSpaces(lastPart, preserveQuotation);
            lastWord = lastPartParts[lastPartParts.length - 1];
        }
        return lastWord;
    }

    public static String[] splitAndKeepEscapedSpaces(String string2, boolean preserveEscapes) {
        ArrayList<String> result2 = new ArrayList<String>();
        StringBuilder current = new StringBuilder();
        for (int i = 0; i < string2.length(); ++i) {
            char ch = string2.charAt(i);
            if (ch == ' ') {
                boolean isGluedSpace;
                boolean bl = isGluedSpace = i > 0 && string2.charAt(i - 1) == '\\';
                if (!isGluedSpace) {
                    result2.add(current.toString());
                    current = new StringBuilder();
                    continue;
                }
            }
            if (!preserveEscapes && ch == '\\') continue;
            current.append(ch);
        }
        if (current.length() > 0) {
            result2.add(current.toString());
        }
        return result2.toArray(new String[result2.size()]);
    }

    public static String multiplyString(String string2, int times2) {
        StringBuilder result2 = new StringBuilder();
        for (int i = 0; i < times2; ++i) {
            result2.append(string2);
        }
        return result2.toString();
    }

    public static String removeSpaces(String command) {
        while (command.length() > 0 && command.charAt(0) == ' ') {
            command = command.substring(1);
        }
        while (command.length() > 0 && command.charAt(command.length() - 1) == ' ') {
            command = command.substring(0, command.length() - 1);
        }
        return command;
    }

    public static String[] tokenizeStringWithQuotes(String string2) {
        return TextUtil.tokenizeStringWithQuotes(string2, true);
    }

    public static String[] tokenizeStringWithQuotes(String string2, boolean trim) {
        if (trim) {
            string2 = string2.trim();
        }
        ArrayList<String> result2 = new ArrayList<String>();
        string2 = string2.trim();
        boolean inside = string2.startsWith("\"");
        StringTokenizer quoteTokenizer = new StringTokenizer(string2, "\"");
        while (quoteTokenizer.hasMoreTokens()) {
            String token = quoteTokenizer.nextToken();
            if (trim) {
                token = token.trim();
            }
            if (token.length() != 0) {
                if (inside) {
                    result2.add(token);
                } else {
                    Collections.addAll(result2, TextUtil.splitAndKeepEscapedSpaces(token, false));
                }
            }
            inside = !inside;
        }
        return result2.toArray(new String[result2.size()]);
    }

    public static String stripFromQuotes(String string2) {
        if (string2 != null && string2.startsWith("\"") && string2.endsWith("\"")) {
            return string2.substring(1, string2.length() - 1);
        }
        return string2;
    }
}

