/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shell;

import java.io.File;
import java.util.Arrays;
import java.util.Random;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.factory.GraphDatabaseBuilder;
import org.neo4j.graphdb.factory.GraphDatabaseFactory;

public class BigLabelStoreGenerator {
    private static Random random = new Random();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        long batchSize = Long.parseLong(BigLabelStoreGenerator.withDefault(System.getenv().get("BATCH_SIZE"), "100000"));
        long numNodes = Long.parseLong(BigLabelStoreGenerator.withDefault(System.getenv("NUM_NODES"), "1000000"));
        int numLabels = Integer.parseInt(BigLabelStoreGenerator.withDefault(System.getenv("NUM_LABELS"), "5"));
        File graphDbPath = new File(System.getenv("GRAPH_DB"));
        System.out.println(String.format("# BATCH_SIZE: %d, NUM_NODES: %d, NUM_LABELS: %d, GRAPH_DB: '%s'", batchSize, numNodes, numLabels, graphDbPath));
        GraphDatabaseService graph = BigLabelStoreGenerator.createGraphDatabaseService(graphDbPath);
        Label[] labels2 = BigLabelStoreGenerator.createLabels(numLabels);
        int[] statistics2 = new int[numLabels];
        assert (numLabels == labels2.length);
        long labelings = 0L;
        long start = System.currentTimeMillis();
        try {
            for (long l = 0L; l < numNodes; l += batchSize) {
                long batchStart = System.currentTimeMillis();
                try (Transaction tx = graph.beginTx();){
                    for (long m = 0L; m < batchSize; ++m) {
                        Label[] selectedLabels = BigLabelStoreGenerator.pickRandomLabels(labels2);
                        int i = 0;
                        while (i < selectedLabels.length) {
                            int n = i++;
                            statistics2[n] = statistics2[n] + 1;
                        }
                        labelings += (long)selectedLabels.length;
                        graph.createNode(selectedLabels);
                    }
                    tx.success();
                }
                long batchDuration = System.currentTimeMillis() - batchStart;
                System.out.println(String.format("nodes: %d, ratio: %d, labelings: %d, duration: %d, label statistics: %s", l, l * 100L / numNodes, labelings, batchDuration, Arrays.toString(statistics2)));
            }
        }
        finally {
            graph.shutdown();
        }
        long duration = System.currentTimeMillis() - start;
        System.out.println(String.format("nodes: %d, ratio: %d, labelings: %d, duration: %d", numNodes, 100, labelings, duration));
    }

    private static GraphDatabaseService createGraphDatabaseService(File graphDbPath) {
        GraphDatabaseFactory factory = new GraphDatabaseFactory();
        GraphDatabaseBuilder graphBuilder = factory.newEmbeddedDatabaseBuilder(graphDbPath);
        File configFile = new File(graphDbPath, "neo4j.conf");
        if (configFile.exists() && configFile.isFile() && configFile.canRead()) {
            System.out.println(String.format("# Loading config file '%s'", configFile.getAbsolutePath()));
            graphBuilder.loadPropertiesFromFile(configFile.getAbsolutePath());
        } else {
            System.out.println(String.format("# No config file found at '%s'", configFile.getAbsolutePath()));
        }
        return graphBuilder.newGraphDatabase();
    }

    private static String withDefault(String value, String defaultValue) {
        return null == value ? defaultValue : value;
    }

    private static Label[] pickRandomLabels(Label[] labels2) {
        return Arrays.copyOf(labels2, 1 + random.nextInt(labels2.length));
    }

    private static Label[] createLabels(int numLabels) {
        Label[] labels2 = new Label[numLabels];
        for (int i = 0; i < numLabels; ++i) {
            labels2[i] = Label.label(String.format("LABEL_%d", i));
        }
        return labels2;
    }
}

