/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.security.auth;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.neo4j.server.security.auth.Credential;
import org.neo4j.server.security.auth.User;
import org.neo4j.string.HexString;
import org.neo4j.string.UTF8;

public class UserSerialization {
    private static final String userSeparator = ":";
    private static final String credentialSeparator = ",";

    public byte[] serialize(Collection<User> users) {
        StringBuilder sb = new StringBuilder();
        for (User user : users) {
            sb.append(this.serialize(user)).append("\n");
        }
        return UTF8.encode(sb.toString());
    }

    public List<User> deserializeUsers(byte[] bytes2) throws FormatException {
        ArrayList<User> out = new ArrayList<User>();
        int lineNumber = 1;
        for (String line : UTF8.decode(bytes2).split("\n")) {
            if (line.trim().length() > 0) {
                out.add(this.deserializeUser(line, lineNumber));
            }
            ++lineNumber;
        }
        return out;
    }

    private String serialize(User user) {
        return this.join(userSeparator, user.name(), this.serialize(user.credentials()), user.passwordChangeRequired() ? "password_change_required" : "");
    }

    private User deserializeUser(String line, int lineNumber) throws FormatException {
        String[] parts = line.split(userSeparator, -1);
        if (parts.length != 3) {
            throw new FormatException(String.format("wrong number of line fields [line %d]", lineNumber));
        }
        return new User.Builder().withName(parts[0]).withCredentials(this.deserializeCredentials(parts[1], lineNumber)).withRequiredPasswordChange(parts[2].equals("password_change_required")).build();
    }

    private String serialize(Credential cred) {
        String encodedSalt = HexString.encodeHexString(cred.salt());
        String encodedPassword = HexString.encodeHexString(cred.passwordHash());
        return this.join(credentialSeparator, "SHA-256", encodedPassword, encodedSalt);
    }

    private Credential deserializeCredentials(String part, int lineNumber) throws FormatException {
        String[] split2 = part.split(credentialSeparator, -1);
        if (split2.length != 3) {
            throw new FormatException(String.format("wrong number of credential fields [line %d]", lineNumber));
        }
        if (!split2[0].equals("SHA-256")) {
            throw new FormatException(String.format("unknown digest \"%s\" [line %d]", split2[0], lineNumber));
        }
        byte[] decodedPassword = HexString.decodeHexString(split2[1]);
        byte[] decodedSalt = HexString.decodeHexString(split2[2]);
        return new Credential(decodedSalt, decodedPassword);
    }

    private String join(String separator, String ... segments2) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < segments2.length; ++i) {
            if (i > 0) {
                sb.append(separator);
            }
            sb.append(segments2[i] == null ? "" : segments2[i]);
        }
        return sb.toString();
    }

    public class FormatException
    extends Exception {
        FormatException(String message) {
            super(message);
        }
    }
}

