/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.security.auth;

import java.io.IOException;
import org.neo4j.kernel.api.security.AccessMode;
import org.neo4j.server.security.auth.AuthSubject;
import org.neo4j.server.security.auth.AuthenticationResult;
import org.neo4j.server.security.auth.BasicAuthManager;
import org.neo4j.server.security.auth.User;
import org.neo4j.server.security.auth.exception.IllegalCredentialsException;

public class BasicAuthSubject
implements AuthSubject {
    private final BasicAuthManager authManager;
    private User user;
    private AuthenticationResult authenticationResult;
    private final AccessMode.Static accessMode;

    public BasicAuthSubject(BasicAuthManager authManager, User user, AuthenticationResult authenticationResult) {
        this.authManager = authManager;
        this.user = user;
        this.authenticationResult = authenticationResult;
        this.accessMode = authenticationResult == AuthenticationResult.SUCCESS ? AccessMode.Static.FULL : AccessMode.Static.NONE;
    }

    @Override
    public void logout() {
        this.user = null;
        this.authenticationResult = AuthenticationResult.FAILURE;
    }

    @Override
    public AuthenticationResult getAuthenticationResult() {
        return this.authenticationResult;
    }

    @Override
    public void setPassword(String password) throws IOException, IllegalCredentialsException {
        this.validatePassword(password);
        this.authManager.setPassword(this, this.user.name(), password);
    }

    public boolean doesUsernameMatch(String username) {
        return this.user.name().equals(username);
    }

    @Override
    public boolean allowsReads() {
        return this.accessMode.allowsReads();
    }

    @Override
    public boolean allowsWrites() {
        return this.accessMode.allowsWrites();
    }

    @Override
    public boolean allowsSchemaWrites() {
        return this.accessMode.allowsSchemaWrites();
    }

    @Override
    public String name() {
        return this.accessMode.name();
    }

    private void validatePassword(String password) throws IllegalCredentialsException {
        if (password == null || password.isEmpty()) {
            throw new IllegalCredentialsException("Password cannot be empty.");
        }
        if (this.user.credentials().matchesPassword(password)) {
            throw new IllegalCredentialsException("Old password and new password cannot be the same.");
        }
    }
}

