/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.logging.async;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.Objects;
import java.util.TimeZone;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.neo4j.concurrent.AsyncEvent;
import org.neo4j.logging.Log;
import org.neo4j.logging.Logger;

public final class AsyncLogEvent
extends AsyncEvent {
    private final long timestamp;
    private final Object target;
    private final String message;
    private final Object parameter;
    private static final ThreadLocalFormat TIMESTAMP = new ThreadLocalFormat();

    static AsyncLogEvent logEvent(@Nonnull Logger logger, @Nonnull String message) {
        return new AsyncLogEvent(Objects.requireNonNull(logger, "logger"), Objects.requireNonNull(message, "message"), null);
    }

    static AsyncLogEvent logEvent(@Nonnull Logger logger, @Nonnull String message, @Nonnull Throwable throwable) {
        return new AsyncLogEvent(Objects.requireNonNull(logger, "logger"), Objects.requireNonNull(message, "message"), Objects.requireNonNull(throwable, "Throwable"));
    }

    static AsyncLogEvent logEvent(@Nonnull Logger logger, @Nonnull String format2, Object ... arguments2) {
        return new AsyncLogEvent(Objects.requireNonNull(logger, "logger"), Objects.requireNonNull(format2, "format"), arguments2 == null ? new Object[]{} : arguments2);
    }

    static AsyncLogEvent bulkLogEvent(@Nonnull Log log, final @Nonnull Consumer<Log> consumer) {
        Objects.requireNonNull(consumer, "Consumer<Log>");
        return new AsyncLogEvent(Objects.requireNonNull(log, "log"), new BulkLogger(){

            @Override
            void process(long timestamp, Object target) {
                consumer.accept((Log)target);
            }

            public String toString() {
                return "Log.bulkLog( " + consumer + " )";
            }
        });
    }

    static AsyncLogEvent bulkLogEvent(@Nonnull Logger logger, final @Nonnull Consumer<Logger> consumer) {
        Objects.requireNonNull(consumer, "Consumer<Logger>");
        return new AsyncLogEvent(Objects.requireNonNull(logger, "logger"), new BulkLogger(){

            @Override
            void process(long timestamp, Object target) {
                consumer.accept((Logger)target);
            }

            public String toString() {
                return "Logger.bulkLog( " + consumer + " )";
            }
        });
    }

    public void process() {
        if (this.parameter == null) {
            ((Logger)this.target).log("[AsyncLog @ " + this.timestamp() + "]  " + this.message);
        } else if (this.parameter instanceof Throwable) {
            ((Logger)this.target).log("[AsyncLog @ " + this.timestamp() + "]  " + this.message, (Throwable)this.parameter);
        } else if (this.parameter instanceof Object[]) {
            ((Logger)this.target).log("[AsyncLog @ " + this.timestamp() + "]  " + this.message, (Object[])this.parameter);
        } else if (this.parameter instanceof BulkLogger) {
            ((BulkLogger)this.parameter).process(this.timestamp, this.target);
        }
    }

    private AsyncLogEvent(@Nonnull Object target, @Nullable Object parameter) {
        this(target, "", parameter);
    }

    private AsyncLogEvent(@Nonnull Object target, @Nonnull String message, @Nullable Object parameter) {
        this.target = target;
        this.message = message;
        this.parameter = parameter;
        this.timestamp = System.currentTimeMillis();
    }

    public String toString() {
        if (this.parameter == null) {
            return "log( @ " + this.timestamp() + ": \"" + this.message + "\" )";
        }
        if (this.parameter instanceof Throwable) {
            return "log( @ " + this.timestamp() + ": \"" + this.message + "\", " + this.parameter + " )";
        }
        if (this.parameter instanceof Object[]) {
            return "log( @ " + this.timestamp() + ": \"" + this.message + "\", " + Arrays.toString((Object[])this.parameter) + " )";
        }
        if (this.parameter instanceof BulkLogger) {
            return this.parameter.toString();
        }
        return super.toString();
    }

    private String timestamp() {
        return TIMESTAMP.format(this.timestamp);
    }

    private static class ThreadLocalFormat
    extends ThreadLocal<DateFormat> {
        private ThreadLocalFormat() {
        }

        String format(long timestamp) {
            return ((DateFormat)this.get()).format(new Date(timestamp));
        }

        @Override
        protected DateFormat initialValue() {
            SimpleDateFormat format2 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSSZ");
            format2.setTimeZone(TimeZone.getTimeZone("UTC"));
            return format2;
        }
    }

    private static abstract class BulkLogger {
        private BulkLogger() {
        }

        abstract void process(long var1, Object var3);
    }
}

