/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.logging;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.LinkedList;
import java.util.Queue;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import org.neo4j.logging.AbstractLog;
import org.neo4j.logging.Log;
import org.neo4j.logging.Logger;

public class BufferingLog
extends AbstractLog {
    private final Queue<LogMessage> buffer = new LinkedList<LogMessage>();
    private final Logger debugLogger = new BufferingLogger(){

        @Override
        public LogMessage buildMessage(final @Nonnull String message) {
            return new LogMessage(){

                @Override
                public void replayInto(Log other2) {
                    other2.debug(message);
                }

                @Override
                public void printTo(PrintWriter pw) {
                    pw.println(message);
                }
            };
        }

        @Override
        public LogMessage buildMessage(final @Nonnull String message, final @Nonnull Throwable throwable) {
            return new LogMessage(){

                @Override
                public void replayInto(Log other2) {
                    other2.debug(message, throwable);
                }

                @Override
                public void printTo(PrintWriter pw) {
                    pw.println(message);
                    throwable.printStackTrace(pw);
                }
            };
        }

        @Override
        public LogMessage buildMessage(final String format2, final Object ... arguments2) {
            return new LogMessage(){

                @Override
                public void replayInto(Log other2) {
                    other2.debug(format2, arguments2);
                }

                @Override
                public void printTo(PrintWriter pw) {
                    pw.println(String.format(format2, arguments2));
                }
            };
        }
    };
    private final Logger infoLogger = new BufferingLogger(){

        @Override
        public LogMessage buildMessage(final @Nonnull String message) {
            return new LogMessage(){

                @Override
                public void replayInto(Log other2) {
                    other2.info(message);
                }

                @Override
                public void printTo(PrintWriter pw) {
                    pw.println(message);
                }
            };
        }

        @Override
        public LogMessage buildMessage(final @Nonnull String message, final @Nonnull Throwable throwable) {
            return new LogMessage(){

                @Override
                public void replayInto(Log other2) {
                    other2.info(message, throwable);
                }

                @Override
                public void printTo(PrintWriter pw) {
                    pw.println(message);
                    throwable.printStackTrace(pw);
                }
            };
        }

        @Override
        public LogMessage buildMessage(final String format2, final Object ... arguments2) {
            return new LogMessage(){

                @Override
                public void replayInto(Log other2) {
                    other2.info(format2, arguments2);
                }

                @Override
                public void printTo(PrintWriter pw) {
                    pw.println(String.format(format2, arguments2));
                }
            };
        }
    };
    private final Logger warnLogger = new BufferingLogger(){

        @Override
        public LogMessage buildMessage(final @Nonnull String message) {
            return new LogMessage(){

                @Override
                public void replayInto(Log other2) {
                    other2.warn(message);
                }

                @Override
                public void printTo(PrintWriter pw) {
                    pw.println(message);
                }
            };
        }

        @Override
        public LogMessage buildMessage(final @Nonnull String message, final @Nonnull Throwable throwable) {
            return new LogMessage(){

                @Override
                public void replayInto(Log other2) {
                    other2.warn(message, throwable);
                }

                @Override
                public void printTo(PrintWriter pw) {
                    pw.println(message);
                    throwable.printStackTrace(pw);
                }
            };
        }

        @Override
        public LogMessage buildMessage(final String format2, final Object ... arguments2) {
            return new LogMessage(){

                @Override
                public void replayInto(Log other2) {
                    other2.warn(format2, arguments2);
                }

                @Override
                public void printTo(PrintWriter pw) {
                    pw.println(String.format(format2, arguments2));
                }
            };
        }
    };
    private final Logger errorLogger = new BufferingLogger(){

        @Override
        public LogMessage buildMessage(final @Nonnull String message) {
            return new LogMessage(){

                @Override
                public void replayInto(Log other2) {
                    other2.error(message);
                }

                @Override
                public void printTo(PrintWriter pw) {
                    pw.println(message);
                }
            };
        }

        @Override
        public LogMessage buildMessage(final @Nonnull String message, final @Nonnull Throwable throwable) {
            return new LogMessage(){

                @Override
                public void replayInto(Log other2) {
                    other2.error(message, throwable);
                }

                @Override
                public void printTo(PrintWriter pw) {
                    pw.println(message);
                    throwable.printStackTrace(pw);
                }
            };
        }

        @Override
        public LogMessage buildMessage(final String format2, final Object ... arguments2) {
            return new LogMessage(){

                @Override
                public void replayInto(Log other2) {
                    other2.error(format2, arguments2);
                }

                @Override
                public void printTo(PrintWriter pw) {
                    pw.println(String.format(format2, arguments2));
                }
            };
        }
    };

    @Override
    public boolean isDebugEnabled() {
        return true;
    }

    @Override
    @Nonnull
    public Logger debugLogger() {
        return this.debugLogger;
    }

    @Override
    @Nonnull
    public Logger infoLogger() {
        return this.infoLogger;
    }

    @Override
    @Nonnull
    public Logger warnLogger() {
        return this.warnLogger;
    }

    @Override
    @Nonnull
    public Logger errorLogger() {
        return this.errorLogger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void bulk(@Nonnull Consumer<Log> consumer) {
        Queue<LogMessage> queue = this.buffer;
        synchronized (queue) {
            consumer.accept(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replayInto(Log other2) {
        Queue<LogMessage> queue = this.buffer;
        synchronized (queue) {
            LogMessage message = this.buffer.poll();
            while (message != null) {
                message.replayInto(other2);
                message = this.buffer.poll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        Queue<LogMessage> queue = this.buffer;
        synchronized (queue) {
            StringWriter stringWriter = new StringWriter();
            PrintWriter sb = new PrintWriter(stringWriter);
            for (LogMessage message : this.buffer) {
                message.printTo(sb);
            }
            return stringWriter.toString();
        }
    }

    private abstract class BufferingLogger
    implements Logger {
        private BufferingLogger() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void log(@Nonnull String message) {
            LogMessage logMessage = this.buildMessage(message);
            Queue queue = BufferingLog.this.buffer;
            synchronized (queue) {
                BufferingLog.this.buffer.add(logMessage);
            }
        }

        protected abstract LogMessage buildMessage(@Nonnull String var1);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void log(@Nonnull String message, @Nonnull Throwable throwable) {
            LogMessage logMessage = this.buildMessage(message, throwable);
            Queue queue = BufferingLog.this.buffer;
            synchronized (queue) {
                BufferingLog.this.buffer.add(logMessage);
            }
        }

        protected abstract LogMessage buildMessage(String var1, Throwable var2);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void log(@Nonnull String format2, Object ... arguments2) {
            LogMessage logMessage = this.buildMessage(format2, arguments2);
            Queue queue = BufferingLog.this.buffer;
            synchronized (queue) {
                BufferingLog.this.buffer.add(logMessage);
            }
        }

        protected abstract LogMessage buildMessage(String var1, Object ... var2);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void bulk(@Nonnull Consumer<Logger> consumer) {
            Queue queue = BufferingLog.this.buffer;
            synchronized (queue) {
                consumer.accept(this);
            }
        }
    }

    private static interface LogMessage {
        public void replayInto(Log var1);

        public void printTo(PrintWriter var1);
    }
}

