/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.logging;

import java.io.PrintWriter;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import org.neo4j.logging.Logger;

public abstract class AbstractPrintWriterLogger
implements Logger {
    private final Supplier<PrintWriter> writerSupplier;
    private final Object lock;
    private final boolean autoFlush;

    protected AbstractPrintWriterLogger(@Nonnull Supplier<PrintWriter> writerSupplier, @Nonnull Object lock, boolean autoFlush) {
        this.writerSupplier = writerSupplier;
        this.lock = lock;
        this.autoFlush = autoFlush;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void log(@Nonnull String message) {
        PrintWriter writer;
        Objects.requireNonNull(message, "message must not be null");
        Object object = this.lock;
        synchronized (object) {
            writer = this.writerSupplier.get();
            this.writeLog(writer, message);
        }
        this.maybeFlush(writer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void log(@Nonnull String message, @Nonnull Throwable throwable) {
        PrintWriter writer;
        Objects.requireNonNull(message, "message must not be null");
        if (throwable == null) {
            this.log(message);
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            writer = this.writerSupplier.get();
            this.writeLog(writer, message, throwable);
        }
        this.maybeFlush(writer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void log(@Nonnull String format2, Object ... arguments2) {
        PrintWriter writer;
        Objects.requireNonNull(format2, "format must not be null");
        if (arguments2 == null || arguments2.length == 0) {
            this.log(format2);
            return;
        }
        String message = String.format(format2, arguments2);
        Object object = this.lock;
        synchronized (object) {
            writer = this.writerSupplier.get();
            this.writeLog(writer, message);
        }
        this.maybeFlush(writer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void bulk(@Nonnull Consumer<Logger> consumer) {
        PrintWriter writer;
        Objects.requireNonNull(consumer, "consumer must not be null");
        Object object = this.lock;
        synchronized (object) {
            writer = this.writerSupplier.get();
            consumer.accept(this.getBulkLogger(writer, this.lock));
        }
        this.maybeFlush(writer);
    }

    protected abstract void writeLog(@Nonnull PrintWriter var1, @Nonnull String var2);

    protected abstract void writeLog(@Nonnull PrintWriter var1, @Nonnull String var2, @Nonnull Throwable var3);

    protected abstract Logger getBulkLogger(@Nonnull PrintWriter var1, @Nonnull Object var2);

    private void maybeFlush(PrintWriter writer) {
        if (this.autoFlush) {
            writer.flush();
        }
    }
}

