/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.logging;

import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;

public abstract class AbstractLogProvider<T extends Log>
implements LogProvider {
    private final ConcurrentHashMap<String, T> logCache = new ConcurrentHashMap();

    public T getLog(Class loggingClass) {
        return (T)this.getLog(loggingClass.getName(), () -> this.buildLog(loggingClass));
    }

    public T getLog(String name2) {
        return (T)this.getLog(name2, () -> this.buildLog(name2));
    }

    private T getLog(String name2, Supplier<T> logSupplier) {
        Log newLog;
        Log log = (Log)this.logCache.get(name2);
        if (log == null && (log = this.logCache.putIfAbsent(name2, newLog = (Log)logSupplier.get())) == null) {
            log = newLog;
        }
        return (T)log;
    }

    protected Collection<T> cachedLogs() {
        return this.logCache.values();
    }

    protected abstract T buildLog(Class var1);

    protected abstract T buildLog(String var1);
}

