/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.monitoring;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import org.neo4j.kernel.monitoring.ByteCounterMonitor;

public class MonitoredReadableByteChannel
implements ReadableByteChannel {
    private final ReadableByteChannel delegate;
    private final ByteCounterMonitor monitor;

    public MonitoredReadableByteChannel(ReadableByteChannel delegate, ByteCounterMonitor monitor) {
        this.delegate = delegate;
        this.monitor = monitor;
    }

    @Override
    public int read(ByteBuffer dst) throws IOException {
        int result2 = this.delegate.read(dst);
        if (result2 >= 0) {
            this.monitor.bytesRead(result2);
        }
        return result2;
    }

    @Override
    public boolean isOpen() {
        return this.delegate.isOpen();
    }

    @Override
    public void close() throws IOException {
        this.delegate.close();
    }
}

