/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.lifecycle;

import org.neo4j.kernel.lifecycle.LifecycleStatus;

public class LifecycleException
extends RuntimeException {
    private static String humanReadableMessage(Object instance, LifecycleStatus from2, LifecycleStatus to2) {
        switch (to2) {
            case STOPPED: {
                if (from2 == LifecycleStatus.NONE) {
                    return String.format("Component '%s' failed to initialize. Please see attached cause exception.", instance.toString());
                }
                if (from2 != LifecycleStatus.STARTED) break;
                return String.format("Component '%s' failed to stop. Please see attached cause exception.", instance.toString());
            }
            case STARTED: {
                if (from2 != LifecycleStatus.STOPPED) break;
                return String.format("Component '%s' was successfully initialized, but failed to start. Please see attached cause exception.", instance.toString());
            }
            case SHUTDOWN: {
                return String.format("Component '%s' failed to shut down. Please see attached cause exception.", instance.toString());
            }
        }
        return String.format("Failed to transition component '%s' from %s to %s. Please see attached cause exception", instance.toString(), from2.name(), to2.name());
    }

    public LifecycleException(Object instance, LifecycleStatus from2, LifecycleStatus to2, Throwable cause) {
        super(LifecycleException.humanReadableMessage(instance, from2, to2), cause);
    }
}

