/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.internal;

import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import org.neo4j.helpers.Format;
import org.neo4j.kernel.impl.factory.DatabaseInfo;
import org.neo4j.kernel.impl.store.StoreId;
import org.neo4j.kernel.info.DiagnosticsPhase;
import org.neo4j.kernel.info.DiagnosticsProvider;
import org.neo4j.kernel.internal.Version;
import org.neo4j.logging.Logger;

public abstract class KernelDiagnostics
implements DiagnosticsProvider {
    @Override
    public String getDiagnosticsIdentifier() {
        return this.getClass().getDeclaringClass().getSimpleName() + ":" + this.getClass().getSimpleName();
    }

    @Override
    public void acceptDiagnosticsVisitor(Object visitor) {
    }

    @Override
    public void dump(DiagnosticsPhase phase, Logger log) {
        if (phase.isInitialization() || phase.isExplicitlyRequested()) {
            this.dump(log);
        }
    }

    abstract void dump(Logger var1);

    public static class StoreFiles
    extends KernelDiagnostics {
        private final File storeDir;
        private static String FORMAT_DATE_ISO = "yyyy-MM-dd'T'HH:mm:ssZ";
        private final SimpleDateFormat dateFormat;

        public StoreFiles(File storeDir) {
            this.storeDir = storeDir;
            TimeZone tz = TimeZone.getDefault();
            this.dateFormat = new SimpleDateFormat(FORMAT_DATE_ISO);
            this.dateFormat.setTimeZone(tz);
        }

        @Override
        void dump(Logger logger) {
            logger.log(this.getDiskSpace(this.storeDir) + "\nStorage files: (filename : modification date - size)");
            this.logStoreFiles(logger, "  ", this.storeDir);
        }

        private long logStoreFiles(Logger logger, String prefix, File dir) {
            if (!dir.isDirectory()) {
                return 0L;
            }
            File[] files2 = dir.listFiles();
            if (files2 == null) {
                logger.log(prefix + "<INACCESSIBLE>");
                return 0L;
            }
            long total2 = 0L;
            List<File> fileList = Arrays.asList(files2);
            Collections.sort(fileList, new Comparator<File>(){

                @Override
                public int compare(File o1, File o2) {
                    return o1.getName().compareTo(o2.getName());
                }
            });
            for (File file : fileList) {
                long size2;
                String filename = file.getName();
                if (file.isDirectory()) {
                    logger.log(prefix + filename + ":");
                    size2 = this.logStoreFiles(logger, prefix + "  ", file);
                    filename = "- Total";
                } else {
                    size2 = file.length();
                }
                String fileModificationDate = this.getFileModificationDate(file);
                String bytes2 = Format.bytes(size2);
                String fileInformation = String.format("%s%s: %s - %s", prefix, filename, fileModificationDate, bytes2);
                logger.log(fileInformation);
                total2 += size2;
            }
            return total2;
        }

        private String getFileModificationDate(File file) {
            Date modifiedDate = new Date(file.lastModified());
            return this.dateFormat.format(modifiedDate);
        }

        private String getDiskSpace(File storeDir) {
            long free = storeDir.getFreeSpace();
            long total2 = storeDir.getTotalSpace();
            long percentage = total2 != 0L ? free * 100L / total2 : 0L;
            return String.format("Disk space on partition (Total / Free / Free %%): %s / %s / %s", total2, free, percentage);
        }
    }

    public static class Versions
    extends KernelDiagnostics {
        private final DatabaseInfo databaseInfo;
        private final StoreId storeId;

        public Versions(DatabaseInfo databaseInfo, StoreId storeId) {
            this.databaseInfo = databaseInfo;
            this.storeId = storeId;
        }

        @Override
        void dump(Logger logger) {
            logger.log("Graph Database: " + this.databaseInfo + " " + this.storeId);
            logger.log("Kernel version: " + Version.getKernelVersion());
        }
    }
}

