/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.util.diffsets;

import java.util.Collections;
import java.util.Set;
import java.util.function.Predicate;
import org.neo4j.collection.primitive.PrimitiveIntIterator;
import org.neo4j.collection.primitive.PrimitiveLongIterator;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.kernel.impl.util.DiffApplyingPrimitiveIntIterator;
import org.neo4j.kernel.impl.util.DiffApplyingPrimitiveLongIterator;
import org.neo4j.kernel.impl.util.diffsets.SuperDiffSets;
import org.neo4j.storageengine.api.txstate.ReadableDiffSets;

public class DiffSets<T>
extends SuperDiffSets<T, PrimitiveLongIterator>
implements ReadableDiffSets<T> {
    public DiffSets() {
        this(null, null);
    }

    public DiffSets(Set<T> addedElements, Set<T> removedElements) {
        super(addedElements, removedElements);
    }

    @Override
    public PrimitiveLongIterator augment(PrimitiveLongIterator source) {
        return new DiffApplyingPrimitiveLongIterator(source, this.added(false), this.removed(false));
    }

    @Override
    public PrimitiveIntIterator augment(PrimitiveIntIterator source) {
        return new DiffApplyingPrimitiveIntIterator(source, this.added(false), this.removed(false));
    }

    @Override
    public PrimitiveLongIterator augmentWithRemovals(PrimitiveLongIterator source) {
        return new DiffApplyingPrimitiveLongIterator(source, Collections.emptySet(), this.removed(false));
    }

    @Override
    public DiffSets<T> filterAdded(Predicate<T> addedFilter) {
        return new DiffSets<T>(Iterables.asSet(Iterables.filter(addedFilter, this.added(false))), Iterables.asSet(this.removed(false)));
    }
}

