/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.util;

import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.neo4j.helpers.NamedThreadFactory;
import org.neo4j.kernel.impl.util.DebugUtil;
import org.neo4j.kernel.impl.util.JobScheduler;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;

public class Neo4jJobScheduler
extends LifecycleAdapter
implements JobScheduler {
    private ExecutorService globalPool;
    private ScheduledThreadPoolExecutor scheduledExecutor;

    @Override
    public void init() {
        this.globalPool = Executors.newCachedThreadPool(NamedThreadFactory.daemon("neo4j.Pooled" + DebugUtil.trackTest()));
        this.scheduledExecutor = new ScheduledThreadPoolExecutor(2, NamedThreadFactory.daemon("neo4j.Scheduled" + DebugUtil.trackTest()));
    }

    @Override
    public Executor executor(final JobScheduler.Group group2) {
        return new Executor(){

            @Override
            public void execute(Runnable command) {
                Neo4jJobScheduler.this.schedule(group2, command);
            }
        };
    }

    @Override
    public ThreadFactory threadFactory(final JobScheduler.Group group2) {
        return new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                return Neo4jJobScheduler.this.createNewThread(group2, r, JobScheduler.Group.NO_METADATA);
            }
        };
    }

    @Override
    public JobScheduler.JobHandle schedule(JobScheduler.Group group2, Runnable job) {
        return this.schedule(group2, job, JobScheduler.Group.NO_METADATA);
    }

    @Override
    public JobScheduler.JobHandle schedule(JobScheduler.Group group2, Runnable job, Map<String, String> metadata) {
        if (this.globalPool == null) {
            throw new RejectedExecutionException("Scheduler is not started");
        }
        switch (group2.strategy()) {
            case POOLED: {
                return new PooledJobHandle(this.globalPool.submit(job));
            }
            case NEW_THREAD: {
                Thread thread = this.createNewThread(group2, job, metadata);
                thread.start();
                return new SingleThreadHandle(thread);
            }
        }
        throw new IllegalArgumentException("Unsupported strategy for scheduling job: " + (Object)((Object)group2.strategy()));
    }

    @Override
    public JobScheduler.JobHandle scheduleRecurring(JobScheduler.Group group2, Runnable runnable, long period, TimeUnit timeUnit) {
        return this.scheduleRecurring(group2, runnable, 0L, period, timeUnit);
    }

    @Override
    public JobScheduler.JobHandle scheduleRecurring(JobScheduler.Group group2, Runnable runnable, long initialDelay, long period, TimeUnit timeUnit) {
        switch (group2.strategy()) {
            case POOLED: {
                return new PooledJobHandle(this.scheduledExecutor.scheduleAtFixedRate(runnable, initialDelay, period, timeUnit));
            }
        }
        throw new IllegalArgumentException("Unsupported strategy to use for recurring jobs: " + (Object)((Object)group2.strategy()));
    }

    @Override
    public JobScheduler.JobHandle schedule(JobScheduler.Group group2, Runnable runnable, long initialDelay, TimeUnit timeUnit) {
        switch (group2.strategy()) {
            case POOLED: {
                return new PooledJobHandle(this.scheduledExecutor.schedule(runnable, initialDelay, timeUnit));
            }
        }
        throw new IllegalArgumentException("Unsupported strategy to use for delayed jobs: " + (Object)((Object)group2.strategy()));
    }

    @Override
    public void shutdown() {
        RuntimeException exception = null;
        try {
            if (this.globalPool != null) {
                this.globalPool.shutdownNow();
                this.globalPool.awaitTermination(5L, TimeUnit.SECONDS);
                this.globalPool = null;
            }
        }
        catch (RuntimeException e) {
            exception = e;
        }
        catch (InterruptedException e) {
            exception = new RuntimeException(e);
        }
        try {
            if (this.scheduledExecutor != null) {
                this.scheduledExecutor.shutdown();
                this.scheduledExecutor.awaitTermination(5L, TimeUnit.SECONDS);
                this.scheduledExecutor = null;
            }
        }
        catch (RuntimeException e) {
            exception = e;
        }
        catch (InterruptedException e) {
            exception = new RuntimeException(e);
        }
        if (exception != null) {
            throw new RuntimeException("Unable to shut down job scheduler properly.", exception);
        }
    }

    private Thread createNewThread(JobScheduler.Group group2, Runnable job, Map<String, String> metadata) {
        Thread thread = new Thread(null, job, group2.threadName(metadata));
        thread.setDaemon(true);
        return thread;
    }

    private static class SingleThreadHandle
    implements JobScheduler.JobHandle {
        private final Thread thread;

        public SingleThreadHandle(Thread thread) {
            this.thread = thread;
        }

        @Override
        public void cancel(boolean mayInterruptIfRunning) {
            if (mayInterruptIfRunning) {
                this.thread.interrupt();
            }
        }
    }

    private static class PooledJobHandle
    implements JobScheduler.JobHandle {
        private final Future<?> job;

        public PooledJobHandle(Future<?> job) {
            this.job = job;
        }

        @Override
        public void cancel(boolean mayInterruptIfRunning) {
            this.job.cancel(mayInterruptIfRunning);
        }
    }
}

