/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.util;

import java.io.IOException;
import java.lang.reflect.Array;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.util.HashMap;
import java.util.Map;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.storageengine.api.ReadableChannel;
import org.neo4j.storageengine.api.WritableChannel;
import org.neo4j.string.UTF8;

public abstract class IoPrimitiveUtils {
    public static String readString(ReadableChannel channel, int length2) throws IOException {
        assert (length2 >= 0) : "invalid array length " + length2;
        byte[] chars = new byte[length2];
        channel.get(chars, length2);
        return UTF8.decode(chars);
    }

    public static void write3bLengthAndString(WritableChannel channel, String string2) throws IOException {
        byte[] chars = UTF8.encode(string2);
        channel.putShort((short)chars.length);
        channel.put((byte)(chars.length >> 16));
        channel.put(chars, chars.length);
    }

    public static String read3bLengthAndString(ReadableChannel channel) throws IOException {
        short lengthShort = channel.getShort();
        byte lengthByte = channel.get();
        int length2 = lengthByte << 16 | lengthShort & 0xFFFF;
        byte[] chars = new byte[length2];
        channel.get(chars, length2);
        return UTF8.decode(chars);
    }

    public static void write2bLengthAndString(WritableChannel channel, String string2) throws IOException {
        byte[] chars = UTF8.encode(string2);
        channel.putShort((short)chars.length);
        channel.put(chars, chars.length);
    }

    public static String read2bLengthAndString(ReadableChannel channel) throws IOException {
        short length2 = channel.getShort();
        return IoPrimitiveUtils.readString(channel, length2);
    }

    private static char[] readCharArray(ReadableByteChannel channel, ByteBuffer buffer, char[] charArray) throws IOException {
        buffer.clear();
        int charsLeft = charArray.length;
        int maxSize = buffer.capacity() / 2;
        int offset = 0;
        while (charsLeft > 0) {
            if (charsLeft > maxSize) {
                buffer.limit(maxSize * 2);
                charsLeft -= maxSize;
            } else {
                buffer.limit(charsLeft * 2);
                charsLeft = 0;
            }
            if (channel.read(buffer) != buffer.limit()) {
                return null;
            }
            buffer.flip();
            int length2 = buffer.limit() / 2;
            buffer.asCharBuffer().get(charArray, offset, length2);
            offset += length2;
            buffer.clear();
        }
        return charArray;
    }

    public static boolean readAndFlip(ReadableByteChannel channel, ByteBuffer buffer, int bytes2) throws IOException {
        buffer.clear();
        buffer.limit(bytes2);
        while (buffer.hasRemaining()) {
            int read = channel.read(buffer);
            if (read != -1) continue;
            return false;
        }
        buffer.flip();
        return true;
    }

    public static Integer readInt(ReadableByteChannel channel, ByteBuffer buffer) throws IOException {
        return IoPrimitiveUtils.readAndFlip(channel, buffer, 4) ? Integer.valueOf(buffer.getInt()) : null;
    }

    public static byte[] readBytes(ReadableByteChannel channel, byte[] array) throws IOException {
        return IoPrimitiveUtils.readBytes(channel, array, array.length);
    }

    public static byte[] readBytes(ReadableByteChannel channel, byte[] array, int length2) throws IOException {
        return (byte[])(IoPrimitiveUtils.readAndFlip(channel, ByteBuffer.wrap(array), length2) ? array : null);
    }

    public static Map<String, String> read2bMap(ReadableChannel channel) throws IOException {
        int size2 = channel.getShort();
        HashMap<String, String> map2 = new HashMap<String, String>();
        for (int i = 0; i < size2; ++i) {
            String key = IoPrimitiveUtils.read2bLengthAndString(channel);
            String value = IoPrimitiveUtils.read2bLengthAndString(channel);
            map2.put(key, value);
        }
        return map2;
    }

    public static String readLengthAndString(ReadableByteChannel channel, ByteBuffer buffer) throws IOException {
        Integer length2 = IoPrimitiveUtils.readInt(channel, buffer);
        if (length2 != null) {
            char[] chars = new char[length2.intValue()];
            return (chars = IoPrimitiveUtils.readCharArray(channel, buffer, chars)) == null ? null : new String(chars);
        }
        return null;
    }

    public static void writeLengthAndString(StoreChannel channel, ByteBuffer buffer, String value) throws IOException {
        char[] chars = value.toCharArray();
        int length2 = chars.length;
        IoPrimitiveUtils.writeInt(channel, buffer, length2);
        IoPrimitiveUtils.writeChars(channel, buffer, chars);
    }

    private static void writeChars(StoreChannel channel, ByteBuffer buffer, char[] chars) throws IOException {
        int position2 = 0;
        do {
            buffer.clear();
            int leftToWrite = chars.length - position2;
            if (leftToWrite * 2 < buffer.capacity()) {
                buffer.asCharBuffer().put(chars, position2, leftToWrite);
                buffer.limit(leftToWrite * 2);
                channel.write(buffer);
                position2 += leftToWrite;
                continue;
            }
            int length2 = buffer.capacity() / 2;
            buffer.asCharBuffer().put(chars, position2, length2);
            buffer.limit(length2 * 2);
            channel.write(buffer);
            position2 += length2;
        } while (position2 < chars.length);
    }

    public static void writeInt(StoreChannel channel, ByteBuffer buffer, int value) throws IOException {
        buffer.clear();
        buffer.putInt(value);
        buffer.flip();
        channel.write(buffer);
    }

    public static Object[] asArray(Object propertyValue) {
        if (propertyValue.getClass().isArray()) {
            int length2 = Array.getLength(propertyValue);
            Object[] result2 = new Object[length2];
            for (int i = 0; i < length2; ++i) {
                result2[i] = Array.get(propertyValue, i);
            }
            return result2;
        }
        return new Object[]{propertyValue};
    }

    public static int safeCastLongToInt(long value) {
        if (value >= Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Casting long value " + value + " to an int would wrap around");
        }
        return (int)value;
    }

    public static int shortToUnsignedInt(short value) {
        return value & 0xFFFF;
    }
}

