/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.util;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.function.ToIntFunction;
import org.neo4j.collection.primitive.PrimitiveIntIterator;
import org.neo4j.cursor.Cursor;
import org.neo4j.graphdb.Resource;

public class Cursors {
    private static Cursor<Object> EMPTY = new Cursor<Object>(){

        @Override
        public boolean next() {
            return false;
        }

        @Override
        public Object get() {
            return null;
        }

        @Override
        public void close() {
        }
    };

    public static <T> Cursor<T> empty() {
        return EMPTY;
    }

    public static <T> Cursor<T> cursor(final T ... items) {
        return new Cursor<T>(){
            int idx = 0;
            T current;

            @Override
            public boolean next() {
                if (this.idx < items.length) {
                    this.current = items[this.idx++];
                    return true;
                }
                return false;
            }

            @Override
            public void close() {
                this.idx = 0;
                this.current = null;
            }

            @Override
            public T get() {
                if (this.current == null) {
                    throw new IllegalStateException();
                }
                return this.current;
            }
        };
    }

    public static <T> Cursor<T> cursor(final Iterable<T> items) {
        return new Cursor<T>(){
            Iterator<T> iterator;
            T current;
            {
                this.iterator = items.iterator();
            }

            @Override
            public boolean next() {
                if (this.iterator.hasNext()) {
                    this.current = this.iterator.next();
                    return true;
                }
                return false;
            }

            @Override
            public void close() {
                this.iterator = items.iterator();
                this.current = null;
            }

            @Override
            public T get() {
                if (this.current == null) {
                    throw new IllegalStateException();
                }
                return this.current;
            }
        };
    }

    public static <T> PrimitiveIntIterator intIterator(Cursor<T> resourceCursor, ToIntFunction<T> map2) {
        return new CursorPrimitiveIntIterator<T>(resourceCursor, map2);
    }

    private static class CursorPrimitiveIntIterator<T>
    implements PrimitiveIntIterator,
    Resource {
        private final ToIntFunction<T> map;
        private Cursor<T> cursor;
        private boolean hasNext;

        public CursorPrimitiveIntIterator(Cursor<T> resourceCursor, ToIntFunction<T> map2) {
            this.map = map2;
            this.cursor = resourceCursor;
            this.hasNext = this.nextCursor();
        }

        private boolean nextCursor() {
            if (this.cursor != null) {
                boolean hasNext2 = this.cursor.next();
                if (!hasNext2) {
                    this.close();
                }
                return hasNext2;
            }
            return false;
        }

        @Override
        public boolean hasNext() {
            return this.hasNext;
        }

        @Override
        public int next() {
            if (this.hasNext) {
                try {
                    int n = this.map.applyAsInt(this.cursor.get());
                    return n;
                }
                finally {
                    this.hasNext = this.nextCursor();
                }
            }
            throw new NoSuchElementException();
        }

        @Override
        public void close() {
            if (this.cursor != null) {
                this.cursor.close();
                this.cursor = null;
            }
        }
    }
}

