/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.util;

import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class CopyOnWriteHashMap<K, V>
implements Map<K, V> {
    private volatile Map<K, V> actual = new HashMap();

    @Override
    public int size() {
        return this.actual.size();
    }

    @Override
    public boolean isEmpty() {
        return this.actual.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.actual.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.actual.containsValue(value);
    }

    @Override
    public V get(Object key) {
        return this.actual.get(key);
    }

    private Map<K, V> copy() {
        return new HashMap<K, V>(this.actual);
    }

    @Override
    public synchronized V put(K key, V value) {
        Map<K, V> copy2 = this.copy();
        V previous = copy2.put(key, value);
        this.actual = copy2;
        return previous;
    }

    @Override
    public synchronized V remove(Object key) {
        Map<K, V> copy2 = this.copy();
        V previous = copy2.remove(key);
        this.actual = copy2;
        return previous;
    }

    @Override
    public synchronized void putAll(Map<? extends K, ? extends V> m) {
        Map<? extends K, ? extends V> copy2 = this.copy();
        copy2.putAll(m);
        this.actual = copy2;
    }

    @Override
    public synchronized void clear() {
        this.actual = new HashMap();
    }

    @Override
    public Set<K> keySet() {
        return new AbstractSet<K>(){

            @Override
            public boolean remove(Object o) {
                return CopyOnWriteHashMap.this.remove(o) != null;
            }

            @Override
            public Iterator<K> iterator() {
                return new UnsupportedRemoveIterator(CopyOnWriteHashMap.this.actual.keySet().iterator());
            }

            @Override
            public int size() {
                return CopyOnWriteHashMap.this.actual.size();
            }
        };
    }

    @Override
    public Collection<V> values() {
        return new AbstractCollection<V>(){

            @Override
            public Iterator<V> iterator() {
                return new UnsupportedRemoveIterator(CopyOnWriteHashMap.this.actual.values().iterator());
            }

            @Override
            public int size() {
                return CopyOnWriteHashMap.this.actual.size();
            }
        };
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return new AbstractSet<Map.Entry<K, V>>(){

            @Override
            public boolean remove(Object o) {
                throw new UnsupportedOperationException();
            }

            @Override
            public Iterator<Map.Entry<K, V>> iterator() {
                return new UnsupportedRemoveIterator<Map.Entry<K, V>>(CopyOnWriteHashMap.this.actual.entrySet().iterator()){

                    @Override
                    public Map.Entry<K, V> next() {
                        final Map.Entry actualNext = (Map.Entry)super.next();
                        return new Map.Entry<K, V>(){

                            @Override
                            public K getKey() {
                                return actualNext.getKey();
                            }

                            @Override
                            public V getValue() {
                                return actualNext.getValue();
                            }

                            @Override
                            public V setValue(V value) {
                                throw new UnsupportedOperationException();
                            }

                            @Override
                            public boolean equals(Object obj) {
                                return actualNext.equals(obj);
                            }

                            @Override
                            public int hashCode() {
                                return actualNext.hashCode();
                            }
                        };
                    }
                };
            }

            @Override
            public int size() {
                return CopyOnWriteHashMap.this.actual.size();
            }
        };
    }

    private static class UnsupportedRemoveIterator<T>
    implements Iterator<T> {
        private final Iterator<T> actual;

        UnsupportedRemoveIterator(Iterator<T> actual2) {
            this.actual = actual2;
        }

        @Override
        public boolean hasNext() {
            return this.actual.hasNext();
        }

        @Override
        public T next() {
            return this.actual.next();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

