/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.util;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.function.Function;
import org.neo4j.kernel.impl.util.NumberAwareStringComparator;
import org.neo4j.kernel.impl.util.Validators;

public class Converters {
    public static final Comparator<File> BY_FILE_NAME = (o1, o2) -> o1.getName().compareTo(o2.getName());
    public static final Comparator<File> BY_FILE_NAME_WITH_CLEVER_NUMBERS = (o1, o2) -> NumberAwareStringComparator.INSTANCE.compare(o1.getAbsolutePath(), o2.getAbsolutePath());

    public static <T> Function<String, T> mandatory() {
        return key -> {
            throw new IllegalArgumentException("Missing argument '" + key + "'");
        };
    }

    public static <T> Function<String, T> optional() {
        return from2 -> null;
    }

    public static <T> Function<String, T> withDefault(T defaultValue) {
        return from2 -> defaultValue;
    }

    public static Function<String, File> toFile() {
        return File::new;
    }

    public static Function<String, File[]> regexFiles(boolean cleverNumberRegexSort) {
        return name2 -> {
            Comparator<File> sorting = cleverNumberRegexSort ? BY_FILE_NAME_WITH_CLEVER_NUMBERS : BY_FILE_NAME;
            List<File> files2 = Validators.matchingFiles(new File((String)name2));
            Collections.sort(files2, sorting);
            return files2.toArray(new File[files2.size()]);
        };
    }

    public static Function<String, File[]> toFiles(String delimiter, Function<String, File[]> eachFileConverter) {
        return from2 -> {
            if (from2 == null) {
                return new File[0];
            }
            String[] names = from2.split(delimiter);
            ArrayList<File> files2 = new ArrayList<File>();
            for (String name2 : names) {
                for (File file : (File[])eachFileConverter.apply(name2)) {
                    files2.add(file);
                }
            }
            return files2.toArray(new File[files2.size()]);
        };
    }

    public static Function<String, Integer> toInt() {
        return Integer::new;
    }
}

