/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.util;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;

public class ArrayMap<K, V> {
    private Object data;
    private volatile byte arrayCount;
    private byte toMapThreshold = (byte)5;
    private final boolean useThreadSafeMap;
    private final boolean switchBackToArray;

    public ArrayMap() {
        this.switchBackToArray = false;
        this.useThreadSafeMap = false;
        this.data = new ArrayEntry[this.toMapThreshold];
    }

    public ArrayMap(byte mapThreshold, boolean threadSafe, boolean shrinkToArray) {
        this.toMapThreshold = mapThreshold;
        this.useThreadSafeMap = threadSafe;
        this.switchBackToArray = shrinkToArray;
        this.data = new ArrayEntry[this.toMapThreshold];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        Object snapshot;
        int size2;
        if (this.useThreadSafeMap) {
            ArrayMap arrayMap = this;
            synchronized (arrayMap) {
                size2 = this.arrayCount;
                snapshot = this.data;
            }
        } else {
            size2 = this.arrayCount;
            snapshot = this.data;
        }
        if (size2 != -1) {
            StringBuilder result2 = new StringBuilder();
            String sep = "[";
            for (int i = 0; i < size2; ++i) {
                result2.append(sep).append(((ArrayEntry[])snapshot)[i]);
                sep = ", ";
            }
            return result2.append("]").toString();
        }
        return snapshot.toString();
    }

    public void put(K key, V value) {
        if (this.useThreadSafeMap) {
            this.synchronizedPut(key, value);
            return;
        }
        for (int i = 0; i < this.arrayCount; ++i) {
            if (!((ArrayEntry[])this.data)[i].getKey().equals(key)) continue;
            ((ArrayEntry[])this.data)[i].setNewValue(value);
            return;
        }
        if (this.arrayCount != -1) {
            if (this.arrayCount < ((ArrayEntry[])this.data).length) {
                byte by2 = this.arrayCount;
                this.arrayCount = (byte)(by2 + 1);
                ((ArrayEntry[])this.data)[by2] = new ArrayEntry<K, V>(key, value);
            } else {
                HashMap<K, V> propertyMap = new HashMap<K, V>(((ArrayEntry[])this.data).length * 2);
                for (int i = 0; i < this.arrayCount; ++i) {
                    propertyMap.put(((ArrayEntry[])this.data)[i].getKey(), ((ArrayEntry[])this.data)[i].getValue());
                }
                this.data = propertyMap;
                this.arrayCount = (byte)-1;
                propertyMap.put(key, value);
            }
        } else {
            ((Map)this.data).put(key, value);
        }
    }

    private synchronized void synchronizedPut(K key, V value) {
        for (int i = 0; i < this.arrayCount; ++i) {
            if (!((ArrayEntry[])this.data)[i].getKey().equals(key)) continue;
            ((ArrayEntry[])this.data)[i].setNewValue(value);
            return;
        }
        if (this.arrayCount != -1) {
            if (this.arrayCount < ((ArrayEntry[])this.data).length) {
                byte by2 = this.arrayCount;
                this.arrayCount = (byte)(by2 + 1);
                ((ArrayEntry[])this.data)[by2] = new ArrayEntry<K, V>(key, value);
            } else {
                HashMap<K, V> propertyMap = new HashMap<K, V>(((ArrayEntry[])this.data).length * 2);
                for (int i = 0; i < this.arrayCount; ++i) {
                    propertyMap.put(((ArrayEntry[])this.data)[i].getKey(), ((ArrayEntry[])this.data)[i].getValue());
                }
                this.data = propertyMap;
                this.arrayCount = (byte)-1;
                propertyMap.put(key, value);
            }
        } else {
            ((Map)this.data).put(key, value);
        }
    }

    public V get(K key) {
        if (key == null) {
            return null;
        }
        if (this.useThreadSafeMap) {
            return this.synchronizedGet(key);
        }
        int count2 = this.arrayCount;
        for (int i = 0; i < count2; ++i) {
            ArrayEntry entry = ((ArrayEntry[])this.data)[i];
            if (entry == null || !key.equals(entry.getKey())) continue;
            return entry.getValue();
        }
        if (this.arrayCount == -1) {
            return ((Map)this.data).get(key);
        }
        return null;
    }

    private synchronized V synchronizedGet(K key) {
        int count2 = this.arrayCount;
        for (int i = 0; i < count2; ++i) {
            ArrayEntry entry = ((ArrayEntry[])this.data)[i];
            if (entry == null || !key.equals(entry.getKey())) continue;
            return entry.getValue();
        }
        if (this.arrayCount == -1) {
            return ((Map)this.data).get(key);
        }
        return null;
    }

    private synchronized V synchronizedRemove(K key) {
        for (int i = 0; i < this.arrayCount; ++i) {
            if (!((ArrayEntry[])this.data)[i].getKey().equals(key)) continue;
            Object removedProperty = ((ArrayEntry[])this.data)[i].getValue();
            this.arrayCount = (byte)(this.arrayCount - 1);
            System.arraycopy(this.data, i + 1, this.data, i, this.arrayCount - i);
            ((ArrayEntry[])this.data)[this.arrayCount] = null;
            return removedProperty;
        }
        if (this.arrayCount == -1) {
            Object value = ((Map)this.data).remove(key);
            if (this.switchBackToArray && ((Map)this.data).size() < this.toMapThreshold) {
                ArrayEntry[] arrayEntries = new ArrayEntry[this.toMapThreshold];
                int tmpCount = 0;
                Iterator iterator2 = ((Map)this.data).entrySet().iterator();
                while (iterator2.hasNext()) {
                    Map.Entry entryObject;
                    Map.Entry entry = entryObject = iterator2.next();
                    arrayEntries[tmpCount++] = new ArrayEntry(entry.getKey(), entry.getValue());
                }
                this.data = arrayEntries;
                this.arrayCount = (byte)tmpCount;
            }
            return value;
        }
        return null;
    }

    public V remove(K key) {
        if (this.useThreadSafeMap) {
            return this.synchronizedRemove(key);
        }
        for (int i = 0; i < this.arrayCount; ++i) {
            if (!((ArrayEntry[])this.data)[i].getKey().equals(key)) continue;
            Object removedProperty = ((ArrayEntry[])this.data)[i].getValue();
            this.arrayCount = (byte)(this.arrayCount - 1);
            System.arraycopy(this.data, i + 1, this.data, i, this.arrayCount - i);
            ((ArrayEntry[])this.data)[this.arrayCount] = null;
            return removedProperty;
        }
        if (this.arrayCount == -1) {
            Object value = ((Map)this.data).remove(key);
            if (this.switchBackToArray && ((Map)this.data).size() < this.toMapThreshold) {
                ArrayEntry[] arrayEntries = new ArrayEntry[this.toMapThreshold];
                int tmpCount = 0;
                Iterator iterator2 = ((Map)this.data).entrySet().iterator();
                while (iterator2.hasNext()) {
                    Map.Entry entryObject;
                    Map.Entry entry = entryObject = iterator2.next();
                    arrayEntries[tmpCount++] = new ArrayEntry(entry.getKey(), entry.getValue());
                }
                this.data = arrayEntries;
                this.arrayCount = (byte)tmpCount;
            }
            return value;
        }
        return null;
    }

    public Iterable<K> keySet() {
        if (this.arrayCount == -1) {
            return ((Map)this.data).keySet();
        }
        LinkedList keys2 = new LinkedList();
        for (int i = 0; i < this.arrayCount; ++i) {
            keys2.add(((ArrayEntry[])this.data)[i].getKey());
        }
        return keys2;
    }

    public Iterable<V> values() {
        if (this.arrayCount == -1) {
            return ((Map)this.data).values();
        }
        LinkedList values2 = new LinkedList();
        for (int i = 0; i < this.arrayCount; ++i) {
            values2.add(((ArrayEntry[])this.data)[i].getValue());
        }
        return values2;
    }

    public int size() {
        if (this.useThreadSafeMap) {
            return this.synchronizedSize();
        }
        if (this.arrayCount != -1) {
            return this.arrayCount;
        }
        return ((Map)this.data).size();
    }

    private synchronized int synchronizedSize() {
        if (this.arrayCount != -1) {
            return this.arrayCount;
        }
        return ((Map)this.data).size();
    }

    public void clear() {
        if (this.useThreadSafeMap) {
            this.synchronizedClear();
            return;
        }
        if (this.arrayCount != -1) {
            Arrays.fill((ArrayEntry[])this.data, null);
            this.arrayCount = 0;
        } else {
            ((Map)this.data).clear();
        }
    }

    private synchronized void synchronizedClear() {
        if (this.arrayCount != -1) {
            Arrays.fill((ArrayEntry[])this.data, null);
            this.arrayCount = 0;
        } else {
            ((Map)this.data).clear();
        }
    }

    static class ArrayEntry<K, V>
    implements Map.Entry<K, V> {
        private final K key;
        private V value;

        ArrayEntry(K key, V value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        void setNewValue(V value) {
            this.value = value;
        }

        @Override
        public V setValue(V value) {
            V oldValue = value;
            this.value = value;
            return oldValue;
        }

        public String toString() {
            return this.key + "=" + this.value;
        }
    }
}

