/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.traversal;

import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.traversal.BranchState;
import org.neo4j.graphdb.traversal.Evaluation;
import org.neo4j.graphdb.traversal.PathEvaluator;

public class MultiEvaluator<STATE>
extends PathEvaluator.Adapter<STATE> {
    private final PathEvaluator[] evaluators;

    MultiEvaluator(PathEvaluator ... evaluators) {
        this.evaluators = evaluators;
    }

    @Override
    public Evaluation evaluate(Path position2, BranchState<STATE> state) {
        boolean includes2 = true;
        boolean continues = true;
        for (PathEvaluator evaluator : this.evaluators) {
            Evaluation bla = evaluator.evaluate(position2, state);
            if (!bla.includes()) {
                includes2 = false;
                if (!continues) {
                    return Evaluation.EXCLUDE_AND_PRUNE;
                }
            }
            if (bla.continues()) continue;
            continues = false;
            if (includes2) continue;
            return Evaluation.EXCLUDE_AND_PRUNE;
        }
        return Evaluation.of(includes2, continues);
    }

    public MultiEvaluator<STATE> add(PathEvaluator<STATE> evaluator) {
        PathEvaluator[] newArray = new PathEvaluator[this.evaluators.length + 1];
        System.arraycopy(this.evaluators, 0, newArray, 0, this.evaluators.length);
        newArray[newArray.length - 1] = evaluator;
        return new MultiEvaluator<STATE>(newArray);
    }
}

