/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.traversal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PathExpander;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.traversal.Evaluation;
import org.neo4j.graphdb.traversal.InitialBranchState;
import org.neo4j.graphdb.traversal.TraversalBranch;
import org.neo4j.graphdb.traversal.TraversalContext;
import org.neo4j.graphdb.traversal.UniquenessFactory;
import org.neo4j.kernel.impl.traversal.StartNodeTraversalBranch;

class AsOneStartBranch
implements TraversalBranch {
    private Iterator<TraversalBranch> branches;
    private int expanded;
    private final TraversalContext context;
    private final InitialBranchState initialState;
    private final UniquenessFactory uniqueness;

    AsOneStartBranch(TraversalContext context, Iterable<Node> nodes, InitialBranchState initialState, UniquenessFactory uniqueness) {
        this.context = context;
        this.initialState = initialState;
        this.uniqueness = uniqueness;
        this.branches = this.toBranches(nodes);
    }

    private Iterator<TraversalBranch> toBranches(Iterable<Node> nodes) {
        if (this.uniqueness.eagerStartBranches()) {
            ArrayList<StartNodeTraversalBranch> result2 = new ArrayList<StartNodeTraversalBranch>();
            for (Node node : nodes) {
                result2.add(new StartNodeTraversalBranch(this.context, this, node, this.initialState));
            }
            return result2.iterator();
        }
        return new TraversalBranchIterator(nodes.iterator());
    }

    @Override
    public TraversalBranch parent() {
        return null;
    }

    @Override
    public int length() {
        return -1;
    }

    @Override
    public Node endNode() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Relationship lastRelationship() {
        throw new UnsupportedOperationException();
    }

    @Override
    public TraversalBranch next(PathExpander expander, TraversalContext metadata) {
        if (this.branches.hasNext()) {
            ++this.expanded;
            return this.branches.next().next(expander, metadata);
        }
        return null;
    }

    @Override
    public int expanded() {
        return this.expanded;
    }

    @Override
    public boolean continues() {
        return true;
    }

    @Override
    public boolean includes() {
        return false;
    }

    @Override
    public void evaluation(Evaluation eval2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void initialize(PathExpander expander, TraversalContext metadata) {
    }

    @Override
    public Node startNode() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterable<Relationship> relationships() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterable<Relationship> reverseRelationships() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterable<Node> nodes() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterable<Node> reverseNodes() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterator<PropertyContainer> iterator() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void prune() {
        this.branches = Collections.emptyList().iterator();
    }

    @Override
    public Object state() {
        throw new UnsupportedOperationException();
    }

    private class TraversalBranchIterator
    implements Iterator<TraversalBranch> {
        private final Iterator<Node> nodeIterator;

        public TraversalBranchIterator(Iterator<Node> nodeIterator) {
            this.nodeIterator = nodeIterator;
        }

        @Override
        public boolean hasNext() {
            return this.nodeIterator.hasNext();
        }

        @Override
        public TraversalBranch next() {
            return new StartNodeTraversalBranch(AsOneStartBranch.this.context, AsOneStartBranch.this, this.nodeIterator.next(), AsOneStartBranch.this.initialState);
        }

        @Override
        public void remove() {
            this.nodeIterator.remove();
        }
    }
}

