/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.state;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.neo4j.collection.primitive.Primitive;
import org.neo4j.collection.primitive.PrimitiveLongCollections;
import org.neo4j.collection.primitive.PrimitiveLongObjectMap;
import org.neo4j.collection.primitive.PrimitiveLongObjectVisitor;
import org.neo4j.collection.primitive.PrimitiveLongSet;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.helpers.collection.Pair;
import org.neo4j.kernel.api.index.NodePropertyUpdate;
import org.neo4j.kernel.api.properties.DefinedProperty;
import org.neo4j.kernel.impl.api.index.PropertyPhysicalToLogicalConverter;
import org.neo4j.kernel.impl.api.index.UpdateMode;
import org.neo4j.kernel.impl.core.IteratingPropertyReceiver;
import org.neo4j.kernel.impl.store.NodeLabelsField;
import org.neo4j.kernel.impl.store.NodeStore;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.PropertyRecord;
import org.neo4j.kernel.impl.store.record.RecordLoad;
import org.neo4j.kernel.impl.transaction.command.Command;
import org.neo4j.kernel.impl.transaction.state.IndexUpdates;
import org.neo4j.kernel.impl.transaction.state.LabelChangeSummary;
import org.neo4j.kernel.impl.transaction.state.PropertyLoader;

public class OnlineIndexUpdates
implements IndexUpdates {
    private final NodeStore nodeStore;
    private final PropertyLoader propertyLoader;
    private final PropertyPhysicalToLogicalConverter converter;
    private final Collection<NodePropertyUpdate> updates = new ArrayList<NodePropertyUpdate>();
    private NodeRecord nodeRecord;

    public OnlineIndexUpdates(NodeStore nodeStore, PropertyLoader propertyLoader, PropertyPhysicalToLogicalConverter converter) {
        this.nodeStore = nodeStore;
        this.propertyLoader = propertyLoader;
        this.converter = converter;
    }

    @Override
    public Iterator<NodePropertyUpdate> iterator() {
        return this.updates.iterator();
    }

    @Override
    public void collectUpdatedNodeIds(PrimitiveLongSet target) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void feed(PrimitiveLongObjectMap<List<Command.PropertyCommand>> propertyCommands, PrimitiveLongObjectMap<Command.NodeCommand> nodeCommands) {
        HashMap<Pair<Long, Integer>, NodePropertyUpdate> propertyChanges = new HashMap<Pair<Long, Integer>, NodePropertyUpdate>();
        this.gatherUpdatesFromPropertyCommands(nodeCommands, propertyCommands, propertyChanges);
        this.gatherUpdatesFromNodeCommands(nodeCommands, propertyCommands, propertyChanges);
    }

    @Override
    public boolean hasUpdates() {
        return !this.updates.isEmpty();
    }

    private void gatherUpdatesFromPropertyCommands(final PrimitiveLongObjectMap<Command.NodeCommand> nodeCommands, PrimitiveLongObjectMap<List<Command.PropertyCommand>> propCommands, Map<Pair<Long, Integer>, NodePropertyUpdate> propertyLookup) {
        propCommands.visitEntries(new PrimitiveLongObjectVisitor<List<Command.PropertyCommand>, RuntimeException>(){

            @Override
            public boolean visited(long nodeId, List<Command.PropertyCommand> propertyCommands) {
                OnlineIndexUpdates.this.gatherUpdatesFromPropertyCommandsForNode(nodeId, nodeCommands, propertyCommands);
                return false;
            }
        });
        for (NodePropertyUpdate update2 : this.updates) {
            if (update2.getUpdateMode() != UpdateMode.CHANGED) continue;
            propertyLookup.put(Pair.of(update2.getNodeId(), update2.getPropertyKeyId()), update2);
        }
    }

    private void gatherUpdatesFromPropertyCommandsForNode(long nodeId, PrimitiveLongObjectMap<Command.NodeCommand> nodeCommands, List<Command.PropertyCommand> propertyCommandsForNode) {
        long[] nodeLabelsAfter;
        long[] nodeLabelsBefore;
        Command.NodeCommand nodeChanges = nodeCommands.get(nodeId);
        if (nodeChanges != null) {
            nodeLabelsBefore = NodeLabelsField.parseLabelsField((NodeRecord)nodeChanges.getBefore()).get(this.nodeStore);
            nodeLabelsAfter = NodeLabelsField.parseLabelsField((NodeRecord)nodeChanges.getAfter()).get(this.nodeStore);
        } else {
            NodeRecord nodeRecord = this.loadNode(nodeId);
            nodeLabelsBefore = nodeLabelsAfter = NodeLabelsField.parseLabelsField(nodeRecord).get(this.nodeStore);
        }
        this.converter.apply(this.updates, Iterables.cast(propertyCommandsForNode), nodeLabelsBefore, nodeLabelsAfter);
    }

    private void gatherUpdatesFromNodeCommands(final PrimitiveLongObjectMap<Command.NodeCommand> nodeCommands, final PrimitiveLongObjectMap<List<Command.PropertyCommand>> propertyCommands, final Map<Pair<Long, Integer>, NodePropertyUpdate> propertyLookup) {
        nodeCommands.visitEntries(new PrimitiveLongObjectVisitor<Command.NodeCommand, RuntimeException>(){

            @Override
            public boolean visited(long key, Command.NodeCommand nodeCommand) {
                OnlineIndexUpdates.this.gatherUpdatesFromNodeCommand(nodeCommand, nodeCommands, propertyCommands, propertyLookup);
                return false;
            }
        });
    }

    private NodeRecord loadNode(long nodeId) {
        if (this.nodeRecord == null) {
            this.nodeRecord = (NodeRecord)this.nodeStore.newRecord();
        }
        this.nodeStore.getRecord(nodeId, this.nodeRecord, RecordLoad.NORMAL);
        return this.nodeRecord;
    }

    private void gatherUpdatesFromNodeCommand(Command.NodeCommand nodeCommand, PrimitiveLongObjectMap<Command.NodeCommand> nodeCommands, PrimitiveLongObjectMap<List<Command.PropertyCommand>> propertyCommands, Map<Pair<Long, Integer>, NodePropertyUpdate> propertyLookup) {
        long nodeId = nodeCommand.getKey();
        long[] labelsBefore = NodeLabelsField.parseLabelsField((NodeRecord)nodeCommand.getBefore()).get(this.nodeStore);
        long[] labelsAfter = NodeLabelsField.parseLabelsField((NodeRecord)nodeCommand.getAfter()).get(this.nodeStore);
        if (nodeCommand.getMode() == Command.Mode.DELETE) {
            return;
        }
        LabelChangeSummary summary = new LabelChangeSummary(labelsBefore, labelsAfter);
        if (!summary.hasAddedLabels() && !summary.hasRemovedLabels()) {
            return;
        }
        Iterator<DefinedProperty> properties = this.nodeFullyLoadProperties(nodeId, nodeCommands, propertyCommands);
        while (properties.hasNext()) {
            DefinedProperty property = properties.next();
            int propertyKeyId = property.propertyKeyId();
            if (summary.hasAddedLabels()) {
                Object value = property.value();
                this.updates.add(NodePropertyUpdate.add(nodeId, propertyKeyId, value, summary.getAddedLabels()));
            }
            if (!summary.hasRemovedLabels()) continue;
            NodePropertyUpdate propertyChange = propertyLookup.get(Pair.of(nodeId, propertyKeyId));
            Object value = propertyChange == null ? property.value() : propertyChange.getValueBefore();
            this.updates.add(NodePropertyUpdate.remove(nodeId, propertyKeyId, value, summary.getRemovedLabels()));
        }
    }

    private Iterator<DefinedProperty> nodeFullyLoadProperties(long nodeId, PrimitiveLongObjectMap<Command.NodeCommand> nodeCommands, PrimitiveLongObjectMap<List<Command.PropertyCommand>> propertyCommands) {
        Command.NodeCommand nodeCommand = nodeCommands.get(nodeId);
        NodeRecord nodeRecord = nodeCommand == null ? this.loadNode(nodeId) : (NodeRecord)nodeCommand.getAfter();
        IteratingPropertyReceiver<DefinedProperty> receiver = new IteratingPropertyReceiver<DefinedProperty>();
        PrimitiveLongObjectMap<PropertyRecord> propertiesById = this.propertiesFromCommandsForNode(propertyCommands.get(nodeId));
        this.propertyLoader.nodeLoadProperties(nodeRecord, propertiesById, receiver);
        return receiver;
    }

    private PrimitiveLongObjectMap<PropertyRecord> propertiesFromCommandsForNode(List<Command.PropertyCommand> propertyCommands) {
        if (propertyCommands == null) {
            return PrimitiveLongCollections.emptyObjectMap();
        }
        PrimitiveLongObjectMap<PropertyRecord> result2 = Primitive.longObjectMap(propertyCommands.size());
        for (Command.PropertyCommand command : propertyCommands) {
            PropertyRecord after = (PropertyRecord)command.getAfter();
            if (!after.inUse() || !after.isNodeSet()) continue;
            result2.put(after.getId(), after);
        }
        return result2;
    }
}

