/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.state;

import java.util.Collection;
import java.util.Iterator;
import java.util.function.IntPredicate;
import org.neo4j.collection.primitive.PrimitiveLongCollections;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.helpers.collection.PrefetchingIterator;
import org.neo4j.helpers.collection.Visitor;
import org.neo4j.kernel.api.exceptions.EntityNotFoundException;
import org.neo4j.kernel.api.index.IndexDescriptor;
import org.neo4j.kernel.api.index.NodePropertyUpdate;
import org.neo4j.kernel.api.labelscan.NodeLabelUpdate;
import org.neo4j.kernel.api.properties.Property;
import org.neo4j.kernel.impl.api.CountsAccessor;
import org.neo4j.kernel.impl.api.index.IndexStoreView;
import org.neo4j.kernel.impl.api.index.NodePropertyUpdates;
import org.neo4j.kernel.impl.api.index.StoreScan;
import org.neo4j.kernel.impl.locking.Lock;
import org.neo4j.kernel.impl.locking.LockService;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.NodeLabelsField;
import org.neo4j.kernel.impl.store.NodeStore;
import org.neo4j.kernel.impl.store.PropertyStore;
import org.neo4j.kernel.impl.store.StoreIdIterator;
import org.neo4j.kernel.impl.store.counts.CountsTracker;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.PropertyBlock;
import org.neo4j.kernel.impl.store.record.PropertyRecord;
import org.neo4j.kernel.impl.store.record.Record;
import org.neo4j.kernel.impl.store.record.RecordLoad;
import org.neo4j.register.Register;
import org.neo4j.storageengine.api.EntityType;
import org.neo4j.storageengine.api.schema.PopulationProgress;

public class NeoStoreIndexStoreView
implements IndexStoreView {
    private final PropertyStore propertyStore;
    private final NodeStore nodeStore;
    private final LockService locks;
    private final CountsTracker counts;

    public NeoStoreIndexStoreView(LockService locks, NeoStores neoStores) {
        this.locks = locks;
        this.propertyStore = neoStores.getPropertyStore();
        this.nodeStore = neoStores.getNodeStore();
        this.counts = neoStores.getCounts();
    }

    @Override
    public Register.DoubleLongRegister indexUpdatesAndSize(IndexDescriptor descriptor, Register.DoubleLongRegister output) {
        return this.counts.indexUpdatesAndSize(descriptor.getLabelId(), descriptor.getPropertyKeyId(), output);
    }

    @Override
    public void replaceIndexCounts(IndexDescriptor descriptor, long uniqueElements, long maxUniqueElements, long indexSize) {
        int labelId = descriptor.getLabelId();
        int propertyKeyId = descriptor.getPropertyKeyId();
        try (CountsAccessor.IndexStatsUpdater updater = this.counts.updateIndexCounts();){
            updater.replaceIndexSample(labelId, propertyKeyId, uniqueElements, maxUniqueElements);
            updater.replaceIndexUpdateAndSize(labelId, propertyKeyId, 0L, indexSize);
        }
    }

    @Override
    public void incrementIndexUpdates(IndexDescriptor descriptor, long updatesDelta) {
        try (CountsAccessor.IndexStatsUpdater updater = this.counts.updateIndexCounts();){
            updater.incrementIndexUpdates(descriptor.getLabelId(), descriptor.getPropertyKeyId(), updatesDelta);
        }
    }

    @Override
    public Register.DoubleLongRegister indexSample(IndexDescriptor descriptor, Register.DoubleLongRegister output) {
        return this.counts.indexSample(descriptor.getLabelId(), descriptor.getPropertyKeyId(), output);
    }

    @Override
    public <FAILURE extends Exception> StoreScan<FAILURE> visitNodes(IntPredicate labelIdFilter, IntPredicate propertyKeyIdFilter, Visitor<NodePropertyUpdates, FAILURE> propertyUpdatesVisitor, Visitor<NodeLabelUpdate, FAILURE> labelUpdateVisitor) {
        return new StoreViewNodeStoreScan<FAILURE>(this.nodeStore, this.locks, this.propertyStore, labelUpdateVisitor, propertyUpdatesVisitor, labelIdFilter, propertyKeyIdFilter);
    }

    @Override
    public void nodeAsUpdates(long nodeId, Collection<NodePropertyUpdate> target) {
        NodeRecord node = (NodeRecord)this.nodeStore.getRecord(nodeId, this.nodeStore.newRecord(), RecordLoad.FORCE);
        if (!node.inUse()) {
            return;
        }
        long firstPropertyId = node.getNextProp();
        if (firstPropertyId == (long)Record.NO_NEXT_PROPERTY.intValue()) {
            return;
        }
        long[] labels2 = NodeLabelsField.parseLabelsField(node).get(this.nodeStore);
        if (labels2.length == 0) {
            return;
        }
        for (PropertyRecord propertyRecord : this.propertyStore.getPropertyRecordChain(firstPropertyId)) {
            for (PropertyBlock property : propertyRecord) {
                Object value = property.getType().getValue(property, this.propertyStore);
                target.add(NodePropertyUpdate.add(node.getId(), property.getKeyIndexId(), value, labels2));
            }
        }
    }

    @Override
    public Property getProperty(long nodeId, int propertyKeyId) throws EntityNotFoundException {
        NodeRecord node = (NodeRecord)this.nodeStore.getRecord(nodeId, this.nodeStore.newRecord(), RecordLoad.FORCE);
        if (!node.inUse()) {
            throw new EntityNotFoundException(EntityType.NODE, nodeId);
        }
        long firstPropertyId = node.getNextProp();
        if (firstPropertyId == (long)Record.NO_NEXT_PROPERTY.intValue()) {
            return Property.noNodeProperty(nodeId, propertyKeyId);
        }
        for (PropertyRecord propertyRecord : this.propertyStore.getPropertyRecordChain(firstPropertyId)) {
            PropertyBlock propertyBlock = propertyRecord.getPropertyBlock(propertyKeyId);
            if (propertyBlock == null) continue;
            return propertyBlock.newPropertyData(this.propertyStore);
        }
        return Property.noNodeProperty(nodeId, propertyKeyId);
    }

    private static boolean containsAnyLabel(IntPredicate labelIdFilter, long[] labels2) {
        for (long candidate : labels2) {
            if (!labelIdFilter.test(Math.toIntExact(candidate))) continue;
            return true;
        }
        return false;
    }

    static class StoreViewNodeStoreScan<FAILURE extends Exception>
    extends NodeStoreScan<FAILURE> {
        private PropertyStore propertyStore;
        private final Visitor<NodeLabelUpdate, FAILURE> labelUpdateVisitor;
        private final Visitor<NodePropertyUpdates, FAILURE> propertyUpdatesVisitor;
        private final IntPredicate labelIdFilter;
        private final IntPredicate propertyKeyIdFilter;
        private NodePropertyUpdates updates;

        StoreViewNodeStoreScan(NodeStore nodeStore, LockService locks, PropertyStore propertyStore, Visitor<NodeLabelUpdate, FAILURE> labelUpdateVisitor, Visitor<NodePropertyUpdates, FAILURE> propertyUpdatesVisitor, IntPredicate labelIdFilter, IntPredicate propertyKeyIdFilter) {
            super(nodeStore, locks, nodeStore.getHighId());
            this.propertyStore = propertyStore;
            this.labelUpdateVisitor = labelUpdateVisitor;
            this.propertyUpdatesVisitor = propertyUpdatesVisitor;
            this.labelIdFilter = labelIdFilter;
            this.propertyKeyIdFilter = propertyKeyIdFilter;
            this.updates = new NodePropertyUpdates();
        }

        @Override
        protected void process(NodeRecord node) throws FAILURE {
            long[] labels2 = NodeLabelsField.parseLabelsField(node).get(this.nodeStore);
            if (labels2.length == 0) {
                return;
            }
            if (this.labelUpdateVisitor != null) {
                this.labelUpdateVisitor.visit(NodeLabelUpdate.labelChanges(node.getId(), PrimitiveLongCollections.EMPTY_LONG_ARRAY, labels2));
            }
            if (this.propertyUpdatesVisitor != null && NeoStoreIndexStoreView.containsAnyLabel(this.labelIdFilter, labels2)) {
                this.updates.initForNodeId(node.getId());
                for (PropertyBlock property : this.properties(node)) {
                    int propertyKeyId = property.getKeyIndexId();
                    if (!this.propertyKeyIdFilter.test(propertyKeyId)) continue;
                    this.updates.add(propertyKeyId, this.valueOf(property), labels2);
                }
                if (this.updates.containsUpdates()) {
                    this.propertyUpdatesVisitor.visit(this.updates);
                    this.updates.reset();
                }
            }
        }

        private Iterable<PropertyBlock> properties(NodeRecord node) {
            return () -> new PropertyBlockIterator(node);
        }

        private Object valueOf(PropertyBlock property) {
            this.propertyStore.ensureHeavy(property);
            return property.getType().getValue(property, this.propertyStore);
        }

        private class PropertyBlockIterator
        extends PrefetchingIterator<PropertyBlock> {
            private final Iterator<PropertyRecord> records;
            private Iterator<PropertyBlock> blocks = Iterators.emptyIterator();

            PropertyBlockIterator(NodeRecord node) {
                long firstPropertyId = node.getNextProp();
                this.records = firstPropertyId == (long)Record.NO_NEXT_PROPERTY.intValue() ? Iterators.emptyIterator() : StoreViewNodeStoreScan.this.propertyStore.getPropertyRecordChain(firstPropertyId).iterator();
            }

            @Override
            protected PropertyBlock fetchNextOrNull() {
                while (!this.blocks.hasNext()) {
                    if (!this.records.hasNext()) {
                        return null;
                    }
                    this.blocks = this.records.next().iterator();
                }
                return this.blocks.next();
            }
        }
    }

    static abstract class NodeStoreScan<FAILURE extends Exception>
    implements StoreScan<FAILURE> {
        private volatile boolean continueScanning;
        private final NodeRecord record;
        protected final NodeStore nodeStore;
        protected final LockService locks;
        private final long totalCount;
        private long count = 0L;

        protected abstract void process(NodeRecord var1) throws FAILURE;

        public NodeStoreScan(NodeStore nodeStore, LockService locks, long totalCount) {
            this.nodeStore = nodeStore;
            this.record = (NodeRecord)nodeStore.newRecord();
            this.locks = locks;
            this.totalCount = totalCount;
        }

        @Override
        public void run() throws FAILURE {
            StoreIdIterator nodeIds = new StoreIdIterator(this.nodeStore);
            this.continueScanning = true;
            while (this.continueScanning && nodeIds.hasNext()) {
                long id = nodeIds.next();
                Lock ignored = this.locks.acquireNodeLock(id, LockService.LockType.READ_LOCK);
                Throwable throwable = null;
                try {
                    ++this.count;
                    if (!this.nodeStore.getRecord(id, this.record, RecordLoad.FORCE).inUse()) continue;
                    this.process(this.record);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (ignored == null) continue;
                    if (throwable != null) {
                        try {
                            ignored.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    ignored.close();
                }
            }
        }

        @Override
        public void stop() {
            this.continueScanning = false;
        }

        @Override
        public PopulationProgress getProgress() {
            if (this.totalCount > 0L) {
                return new PopulationProgress(this.count, this.totalCount);
            }
            return PopulationProgress.DONE;
        }
    }
}

