/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.state;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import org.neo4j.graphdb.Resource;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.kernel.api.labelscan.LabelScanStore;
import org.neo4j.kernel.impl.api.LegacyIndexProviderLookup;
import org.neo4j.kernel.impl.api.index.IndexingService;
import org.neo4j.kernel.spi.legacyindex.IndexImplementation;

public class NeoStoreFileListing {
    private final File storeDir;
    private final LabelScanStore labelScanStore;
    private final IndexingService indexingService;
    private final LegacyIndexProviderLookup legacyIndexProviders;

    public NeoStoreFileListing(File storeDir, LabelScanStore labelScanStore, IndexingService indexingService, LegacyIndexProviderLookup legacyIndexProviders) {
        this.storeDir = storeDir;
        this.labelScanStore = labelScanStore;
        this.indexingService = indexingService;
        this.legacyIndexProviders = legacyIndexProviders;
    }

    public ResourceIterator<File> listStoreFiles(boolean includeLogs) throws IOException {
        ArrayList<File> files2 = new ArrayList<File>();
        this.gatherNeoStoreFiles(files2, includeLogs);
        Resource labelScanStoreSnapshot = this.gatherLabelScanStoreFiles(files2);
        Resource schemaIndexSnapshots = this.gatherSchemaIndexFiles(files2);
        Resource legacyIndexSnapshots = this.gatherLegacyIndexFiles(files2);
        return Iterators.resourceIterator(files2.iterator(), new MultiResource(Arrays.asList(labelScanStoreSnapshot, schemaIndexSnapshots, legacyIndexSnapshots)));
    }

    private Resource gatherLegacyIndexFiles(Collection<File> files2) throws IOException {
        ArrayList<ResourceIterator<File>> snapshots = new ArrayList<ResourceIterator<File>>();
        for (IndexImplementation indexProvider : this.legacyIndexProviders.all()) {
            ResourceIterator<File> snapshot = indexProvider.listStoreFiles();
            snapshots.add(snapshot);
            Iterators.addToCollection(snapshot, files2);
        }
        return new MultiResource(snapshots);
    }

    private Resource gatherSchemaIndexFiles(Collection<File> targetFiles) throws IOException {
        ResourceIterator<File> snapshot = this.indexingService.snapshotStoreFiles();
        Iterators.addToCollection(snapshot, targetFiles);
        return snapshot;
    }

    private Resource gatherLabelScanStoreFiles(Collection<File> targetFiles) throws IOException {
        ResourceIterator<File> snapshot = this.labelScanStore.snapshotStoreFiles();
        Iterators.addToCollection(snapshot, targetFiles);
        return snapshot;
    }

    private void gatherNeoStoreFiles(Collection<File> targetFiles, boolean includeTransactionLogs) {
        File neostoreFile = null;
        for (File dbFile : Objects.requireNonNull(this.storeDir.listFiles())) {
            String name2 = dbFile.getName();
            if (!dbFile.isFile()) continue;
            if (name2.equals("neostore")) {
                neostoreFile = dbFile;
                continue;
            }
            if (this.neoStoreFile(name2)) {
                targetFiles.add(dbFile);
                continue;
            }
            if (!includeTransactionLogs || !this.transactionLogFile(name2)) continue;
            targetFiles.add(dbFile);
        }
        targetFiles.add(neostoreFile);
    }

    private boolean neoStoreFile(String name2) {
        if (name2.endsWith(".id")) {
            return false;
        }
        if (name2.equals("index.db")) {
            return true;
        }
        return name2.startsWith("neostore") && !name2.startsWith("neostore.transaction");
    }

    private boolean transactionLogFile(String name2) {
        return name2.startsWith("neostore.transaction") && !name2.endsWith(".active");
    }

    private static final class MultiResource
    implements Resource {
        private final Collection<? extends Resource> snapshots;

        private MultiResource(Collection<? extends Resource> resources) {
            this.snapshots = resources;
        }

        @Override
        public void close() {
            RuntimeException exception = null;
            for (Resource resource : this.snapshots) {
                try {
                    resource.close();
                }
                catch (RuntimeException e) {
                    exception = e;
                }
            }
            if (exception != null) {
                throw exception;
            }
        }
    }
}

