/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.entry;

import java.io.IOException;
import org.neo4j.helpers.Exceptions;
import org.neo4j.kernel.impl.storageengine.impl.recordstorage.RecordStorageCommandReaderFactory;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.LogPositionMarker;
import org.neo4j.kernel.impl.transaction.log.ReadableClosableChannel;
import org.neo4j.kernel.impl.transaction.log.ReadableClosablePositionAwareChannel;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntry;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryParser;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryReader;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryVersion;
import org.neo4j.storageengine.api.CommandReaderFactory;
import org.neo4j.storageengine.api.ReadPastEndException;

public class VersionAwareLogEntryReader<SOURCE extends ReadableClosablePositionAwareChannel>
implements LogEntryReader<SOURCE> {
    private final CommandReaderFactory commandReaderFactory;

    public VersionAwareLogEntryReader() {
        this(new RecordStorageCommandReaderFactory());
    }

    public VersionAwareLogEntryReader(CommandReaderFactory commandReaderFactory) {
        this.commandReaderFactory = commandReaderFactory;
    }

    @Override
    public LogEntry readLogEntry(SOURCE channel) throws IOException {
        try {
            LogEntry entry;
            LogEntryParser<LogEntry> entryReader;
            LogPositionMarker positionMarker = new LogPositionMarker();
            channel.getCurrentPosition(positionMarker);
            do {
                LogEntryVersion version = null;
                try {
                    byte typeCode = channel.get();
                    byte versionCode = 0;
                    if (typeCode < 0) {
                        versionCode = typeCode;
                        typeCode = channel.get();
                    }
                    version = LogEntryVersion.byVersion(versionCode);
                    entryReader = version.entryParser(typeCode);
                }
                catch (ReadPastEndException e) {
                    throw e;
                }
                catch (Exception e) {
                    LogPosition position2 = positionMarker.newPosition();
                    e = Exceptions.withMessage(e, e.getMessage() + ". At position " + position2 + " and entry version " + (Object)((Object)version));
                    throw Exceptions.launderedException(IOException.class, (Throwable)e);
                }
                entry = entryReader.parse(version, (ReadableClosableChannel)channel, positionMarker, this.commandReaderFactory);
            } while (entryReader.skip());
            return entry;
        }
        catch (ReadPastEndException e) {
            return null;
        }
    }
}

