/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.entry;

import java.io.IOException;
import java.util.Collection;
import org.neo4j.helpers.collection.Visitor;
import org.neo4j.kernel.impl.transaction.TransactionRepresentation;
import org.neo4j.kernel.impl.transaction.log.FlushableChannel;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryVersion;
import org.neo4j.storageengine.api.StorageCommand;

public class LogEntryWriter {
    private final FlushableChannel channel;
    private final Visitor<StorageCommand, IOException> serializer;

    public LogEntryWriter(FlushableChannel channel) {
        this.channel = channel;
        this.serializer = new StorageCommandSerializer(channel);
    }

    private void writeLogEntryHeader(byte type) throws IOException {
        this.channel.put(LogEntryVersion.CURRENT.byteCode()).put(type);
    }

    public void writeStartEntry(int masterId, int authorId, long timeWritten, long latestCommittedTxWhenStarted, byte[] additionalHeaderData) throws IOException {
        this.writeLogEntryHeader((byte)1);
        this.channel.putInt(masterId).putInt(authorId).putLong(timeWritten).putLong(latestCommittedTxWhenStarted).putInt(additionalHeaderData.length).put(additionalHeaderData, additionalHeaderData.length);
    }

    public void writeCommitEntry(long transactionId, long timeWritten) throws IOException {
        this.writeLogEntryHeader((byte)5);
        this.channel.putLong(transactionId).putLong(timeWritten);
    }

    public void serialize(TransactionRepresentation tx) throws IOException {
        tx.accept(this.serializer);
    }

    public void serialize(Collection<StorageCommand> commands) throws IOException {
        for (StorageCommand command : commands) {
            this.serializer.visit(command);
        }
    }

    public void writeCheckPointEntry(LogPosition logPosition) throws IOException {
        this.writeLogEntryHeader((byte)7);
        this.channel.putLong(logPosition.getLogVersion()).putLong(logPosition.getByteOffset());
    }

    private class StorageCommandSerializer
    implements Visitor<StorageCommand, IOException> {
        private final FlushableChannel channel;

        public StorageCommandSerializer(FlushableChannel channel) {
            this.channel = channel;
        }

        @Override
        public boolean visit(StorageCommand command) throws IOException {
            LogEntryWriter.this.writeLogEntryHeader((byte)3);
            command.serialize(this.channel);
            return false;
        }
    }
}

