/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.entry;

import java.io.IOException;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.LogPositionMarker;
import org.neo4j.kernel.impl.transaction.log.ReadableClosableChannel;
import org.neo4j.kernel.impl.transaction.log.entry.CheckPoint;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntry;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryCommand;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryParser;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryStart;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryVersion;
import org.neo4j.kernel.impl.transaction.log.entry.OnePhaseCommit;
import org.neo4j.storageengine.api.CommandReaderFactory;
import org.neo4j.storageengine.api.StorageCommand;

public enum LogEntryParsersV2_3 implements LogEntryParser<LogEntry>
{
    EMPTY{

        @Override
        public LogEntry parse(LogEntryVersion version, ReadableClosableChannel channel, LogPositionMarker marker, CommandReaderFactory commandReader) throws IOException {
            return null;
        }

        @Override
        public byte byteCode() {
            return 0;
        }

        @Override
        public boolean skip() {
            return false;
        }
    }
    ,
    TX_START{

        @Override
        public LogEntry parse(LogEntryVersion version, ReadableClosableChannel channel, LogPositionMarker marker, CommandReaderFactory commandReader) throws IOException {
            LogPosition position2 = marker.newPosition();
            int masterId = channel.getInt();
            int authorId = channel.getInt();
            long timeWritten = channel.getLong();
            long latestCommittedTxWhenStarted = channel.getLong();
            int additionalHeaderLength = channel.getInt();
            byte[] additionalHeader = new byte[additionalHeaderLength];
            channel.get(additionalHeader, additionalHeaderLength);
            return new LogEntryStart(version, masterId, authorId, timeWritten, latestCommittedTxWhenStarted, additionalHeader, position2);
        }

        @Override
        public byte byteCode() {
            return 1;
        }

        @Override
        public boolean skip() {
            return false;
        }
    }
    ,
    COMMAND{

        @Override
        public LogEntry parse(LogEntryVersion version, ReadableClosableChannel channel, LogPositionMarker marker, CommandReaderFactory commandReader) throws IOException {
            StorageCommand command = commandReader.byVersion(version.byteCode()).read(channel);
            return command == null ? null : new LogEntryCommand(version, command);
        }

        @Override
        public byte byteCode() {
            return 3;
        }

        @Override
        public boolean skip() {
            return false;
        }
    }
    ,
    TX_1P_COMMIT{

        @Override
        public LogEntry parse(LogEntryVersion version, ReadableClosableChannel channel, LogPositionMarker marker, CommandReaderFactory commandReader) throws IOException {
            long txId = channel.getLong();
            long timeWritten = channel.getLong();
            return new OnePhaseCommit(version, txId, timeWritten);
        }

        @Override
        public byte byteCode() {
            return 5;
        }

        @Override
        public boolean skip() {
            return false;
        }
    }
    ,
    CHECK_POINT{

        @Override
        public LogEntry parse(LogEntryVersion version, ReadableClosableChannel channel, LogPositionMarker marker, CommandReaderFactory commandReader) throws IOException {
            long logVersion = channel.getLong();
            long byteOffset = channel.getLong();
            return new CheckPoint(version, new LogPosition(logVersion, byteOffset));
        }

        @Override
        public byte byteCode() {
            return 7;
        }

        @Override
        public boolean skip() {
            return false;
        }
    };

}

