/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.entry;

import java.util.TimeZone;
import org.neo4j.helpers.Format;
import org.neo4j.kernel.impl.transaction.log.entry.AbstractLogEntry;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryVersion;

public abstract class LogEntryCommit
extends AbstractLogEntry {
    private final long txId;
    private final long timeWritten;
    protected final String name;

    LogEntryCommit(LogEntryVersion version, byte type, long txId, long timeWritten, String name2) {
        super(version, type);
        this.txId = txId;
        this.timeWritten = timeWritten;
        this.name = name2;
    }

    public long getTxId() {
        return this.txId;
    }

    public long getTimeWritten() {
        return this.timeWritten;
    }

    public String toString() {
        return this.toString(Format.DEFAULT_TIME_ZONE);
    }

    @Override
    public String toString(TimeZone timeZone) {
        return this.name + "[txId=" + this.getTxId() + ", " + this.timestamp(this.getTimeWritten(), timeZone) + "]";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LogEntryCommit commit = (LogEntryCommit)o;
        return this.timeWritten == commit.timeWritten && this.txId == commit.txId && this.name.equals(commit.name);
    }

    public int hashCode() {
        int result2 = (int)(this.txId ^ this.txId >>> 32);
        result2 = 31 * result2 + (int)(this.timeWritten ^ this.timeWritten >>> 32);
        result2 = 31 * result2 + this.name.hashCode();
        return result2;
    }
}

