/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log;

public class LogPosition
implements Comparable<LogPosition> {
    public static final LogPosition UNSPECIFIED = new LogPosition(-1L, -1L){

        @Override
        public long getLogVersion() {
            throw new UnsupportedOperationException();
        }

        @Override
        public long getByteOffset() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String toString() {
            return "UNSPECIFIED";
        }
    };
    private final long logVersion;
    private final long byteOffset;

    public static LogPosition start(long logVersion) {
        return new LogPosition(logVersion, 16L);
    }

    public LogPosition(long logVersion, long byteOffset) {
        this.logVersion = logVersion;
        this.byteOffset = byteOffset;
    }

    public long getLogVersion() {
        return this.logVersion;
    }

    public long getByteOffset() {
        return this.byteOffset;
    }

    public String toString() {
        return "LogPosition{logVersion=" + this.logVersion + ", byteOffset=" + this.byteOffset + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LogPosition that = (LogPosition)o;
        if (this.byteOffset != that.byteOffset) {
            return false;
        }
        return this.logVersion == that.logVersion;
    }

    public int hashCode() {
        int result2 = (int)(this.logVersion ^ this.logVersion >>> 32);
        result2 = 31 * result2 + (int)(this.byteOffset ^ this.byteOffset >>> 32);
        return result2;
    }

    @Override
    public int compareTo(LogPosition o) {
        if (this.logVersion != o.logVersion) {
            return (int)(this.logVersion - o.logVersion);
        }
        return (int)(this.byteOffset - o.byteOffset);
    }
}

