/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.storemigration.legacystore.v21.propertydeduplication;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import org.neo4j.kernel.impl.store.NodeLabelsField;
import org.neo4j.kernel.impl.store.NodeStore;
import org.neo4j.kernel.impl.store.PropertyStore;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.storemigration.legacystore.v21.propertydeduplication.DuplicateCluster;
import org.neo4j.kernel.impl.storemigration.legacystore.v21.propertydeduplication.DuplicatePropertyRemover;
import org.neo4j.kernel.impl.storemigration.legacystore.v21.propertydeduplication.IndexConsultedPropertyBlockSweeper;
import org.neo4j.kernel.impl.storemigration.legacystore.v21.propertydeduplication.IndexLookup;

class DeferredIndexedConflictResolution {
    private final NodeRecord record;
    private final List<DuplicateCluster> duplicateClusterList;
    private NodeStore nodeStore;
    private IndexLookup indexLookup;
    private PropertyStore propertyStore;
    private DuplicatePropertyRemover propertyRemover;

    public DeferredIndexedConflictResolution(NodeRecord record, List<DuplicateCluster> duplicateClusters, NodeStore nodeStore, IndexLookup indexLookup, PropertyStore propertyStore, DuplicatePropertyRemover propertyRemover) {
        this.record = record;
        this.duplicateClusterList = duplicateClusters;
        this.nodeStore = nodeStore;
        this.indexLookup = indexLookup;
        this.propertyStore = propertyStore;
        this.propertyRemover = propertyRemover;
    }

    public void resolve() throws IOException {
        assert (this.duplicateClusterList.size() > 0);
        long[] labelIds = NodeLabelsField.get(this.record, this.nodeStore);
        Iterator<DuplicateCluster> it = this.duplicateClusterList.iterator();
        while (it.hasNext()) {
            DuplicateCluster duplicateCluster = it.next();
            assert (duplicateCluster.size() > 0);
            IndexLookup.Index index = this.indexLookup.getAnyIndexOrNull(labelIds, duplicateCluster.propertyKeyId);
            if (index == null) continue;
            IndexConsultedPropertyBlockSweeper sweeper = new IndexConsultedPropertyBlockSweeper(duplicateCluster.propertyKeyId, index, this.record, this.propertyStore, this.propertyRemover);
            duplicateCluster.propertyRecordIds.visitKeys(sweeper);
            assert (sweeper.foundExact);
            it.remove();
        }
    }
}

