/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.storemigration.legacylogs;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.neo4j.cursor.IOCursor;
import org.neo4j.kernel.impl.transaction.log.ReadableLogChannel;
import org.neo4j.kernel.impl.transaction.log.entry.IdentifiableLogEntry;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntry;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryCommit;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryReader;

class LogEntrySortingCursor
implements IOCursor<LogEntry> {
    private final ReadableLogChannel channel;
    private final LogEntryReader<ReadableLogChannel> reader;
    private final Map<Integer, List<LogEntry>> idToEntries = new HashMap<Integer, List<LogEntry>>();
    private LogEntry toReturn;
    private int idToFetchFrom = -1;

    LogEntrySortingCursor(LogEntryReader<ReadableLogChannel> reader, ReadableLogChannel channel) {
        this.reader = reader;
        this.channel = channel;
    }

    @Override
    public LogEntry get() {
        return this.toReturn;
    }

    @Override
    public boolean next() throws IOException {
        this.perhapsFetchEntriesFromChannel();
        if (this.idToFetchFrom < 0) {
            this.toReturn = null;
            return false;
        }
        List<LogEntry> entries = this.idToEntries.get(this.idToFetchFrom);
        this.toReturn = entries.remove(0);
        if (entries.isEmpty()) {
            this.idToEntries.remove(this.idToFetchFrom);
            this.idToFetchFrom = -1;
        }
        return true;
    }

    private void perhapsFetchEntriesFromChannel() throws IOException {
        LogEntry entry;
        if (this.idToFetchFrom > 0) {
            return;
        }
        while ((entry = this.reader.readLogEntry(this.channel)) != null) {
            if (!(entry instanceof IdentifiableLogEntry)) {
                throw new IllegalStateException("reading from a log which is not a legacy one???");
            }
            IdentifiableLogEntry identifiableLogEntry = (IdentifiableLogEntry)entry;
            int identifier2 = identifiableLogEntry.getIdentifier();
            LogEntry inner2 = identifiableLogEntry.getEntry();
            List<LogEntry> list2 = this.provideList(this.idToEntries, identifier2);
            list2.add(inner2);
            if (!(inner2 instanceof LogEntryCommit)) continue;
            this.idToFetchFrom = identifier2;
            break;
        }
    }

    private List<LogEntry> provideList(Map<Integer, List<LogEntry>> idToEntries, int identifier2) {
        List<LogEntry> list2 = idToEntries.get(identifier2);
        if (list2 == null) {
            list2 = new ArrayList<LogEntry>();
            idToEntries.put(identifier2, list2);
        }
        return list2;
    }

    @Override
    public void close() throws IOException {
        this.channel.close();
    }
}

