/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.storemigration.legacylogs;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.neo4j.cursor.IOCursor;
import org.neo4j.helpers.collection.Pair;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.impl.store.TransactionId;
import org.neo4j.kernel.impl.storemigration.ExistingTargetStrategy;
import org.neo4j.kernel.impl.storemigration.FileOperation;
import org.neo4j.kernel.impl.storemigration.legacylogs.LegacyLogEntryReader;
import org.neo4j.kernel.impl.storemigration.legacylogs.LegacyLogEntryWriter;
import org.neo4j.kernel.impl.storemigration.legacylogs.LegacyLogFilenames;
import org.neo4j.kernel.impl.transaction.log.LogVersionedStoreChannel;
import org.neo4j.kernel.impl.transaction.log.NoSuchTransactionException;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntry;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryCommit;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryStart;
import org.neo4j.kernel.impl.transaction.log.entry.LogHeader;

public class LegacyLogs {
    private final FileSystemAbstraction fs;
    private final LegacyLogEntryReader reader;
    private final LegacyLogEntryWriter writer;
    private final Comparator<File> NEWEST_FIRST = new Comparator<File>(){

        @Override
        public int compare(File o1, File o2) {
            return this.versionOf(o1).compareTo(this.versionOf(o2));
        }

        private Long versionOf(File file) {
            Pair<LogHeader, IOCursor<LogEntry>> pair = null;
            try {
                pair = LegacyLogs.this.reader.openReadableChannel(file);
                LogHeader header = pair.first();
                Long l = header.logVersion;
                return l;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            finally {
                if (pair != null) {
                    try {
                        pair.other().close();
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
        }
    };

    public LegacyLogs(FileSystemAbstraction fs) {
        this(fs, new LegacyLogEntryReader(fs), new LegacyLogEntryWriter(fs));
    }

    LegacyLogs(FileSystemAbstraction fs, LegacyLogEntryReader reader, LegacyLogEntryWriter writer) {
        this.fs = fs;
        this.reader = reader;
        this.writer = writer;
    }

    public void migrateLogs(File storeDir, File migrationDir) throws IOException {
        File[] logFiles;
        for (File file : logFiles = this.fs.listFiles(storeDir, LegacyLogFilenames.versionedLegacyLogFilesFilter)) {
            Pair<LogHeader, IOCursor<LogEntry>> pair = this.reader.openReadableChannel(file);
            LogHeader header = pair.first();
            try (IOCursor<LogEntry> cursor = pair.other();
                 LogVersionedStoreChannel channel = this.writer.openWritableChannel(new File(migrationDir, file.getName()));){
                this.writer.writeLogHeader(channel, header);
                this.writer.writeAllLogEntries(channel, cursor);
            }
        }
    }

    public TransactionId getTransactionInformation(File storeDir, long transactionId) throws IOException {
        List<File> logFiles = Arrays.asList(this.fs.listFiles(storeDir, LegacyLogFilenames.versionedLegacyLogFilesFilter));
        Collections.sort(logFiles, this.NEWEST_FIRST);
        for (File file : logFiles) {
            Pair<LogHeader, IOCursor<LogEntry>> pair = this.reader.openReadableChannel(file);
            boolean hadAnyTransactions = false;
            try (IOCursor<LogEntry> cursor = pair.other();){
                LogEntryStart startEntry = null;
                while (cursor.next()) {
                    LogEntry logEntry = (LogEntry)cursor.get();
                    if (logEntry instanceof LogEntryStart) {
                        startEntry = (LogEntryStart)logEntry;
                        continue;
                    }
                    if (!(logEntry instanceof LogEntryCommit)) continue;
                    hadAnyTransactions = true;
                    LogEntryCommit commitEntry = (LogEntryCommit)logEntry.as();
                    if (commitEntry.getTxId() != transactionId) continue;
                    TransactionId transactionId2 = new TransactionId(transactionId, startEntry.checksum(), commitEntry.getTimeWritten());
                    return transactionId2;
                }
            }
            if (!hadAnyTransactions) continue;
            break;
        }
        throw new NoSuchTransactionException(transactionId);
    }

    public void operate(FileOperation op, File from2, File to2) throws IOException {
        File[] logFiles;
        for (File file : logFiles = this.fs.listFiles(from2, LegacyLogFilenames.versionedLegacyLogFilesFilter)) {
            op.perform(this.fs, file.getName(), from2, false, to2, ExistingTargetStrategy.OVERWRITE);
        }
    }

    public void renameLogFiles(File storeDir) throws IOException {
        for (File file : this.fs.listFiles(storeDir, LegacyLogFilenames.versionedLegacyLogFilesFilter)) {
            String oldName = file.getName();
            long version = LegacyLogFilenames.getLegacyLogVersion(oldName);
            String newName = "neostore.transaction.db." + version;
            this.fs.renameFile(file, new File(file.getParent(), newName));
        }
        this.deleteUnusedLogFiles(storeDir);
    }

    public void deleteUnusedLogFiles(File storeDir) {
        for (File file : this.fs.listFiles(storeDir, LegacyLogFilenames.allLegacyLogFilesFilter)) {
            this.fs.deleteFile(file);
        }
    }
}

