/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.storemigration;

import java.io.File;
import java.io.IOException;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.impl.storemigration.ExistingTargetStrategy;

public enum FileOperation {
    COPY{

        @Override
        public void perform(FileSystemAbstraction fs, String fileName, File fromDirectory, boolean skipNonExistentFromFile, File toDirectory, ExistingTargetStrategy existingTargetStrategy) throws IOException {
            File toFile;
            File fromFile2 = this.fromFile(fs, fromDirectory, fileName, skipNonExistentFromFile);
            if (fromFile2 != null && (toFile = this.toFile(fs, toDirectory, fileName, existingTargetStrategy)) != null) {
                fs.copyFile(fromFile2, toFile);
            }
        }
    }
    ,
    MOVE{

        @Override
        public void perform(FileSystemAbstraction fs, String fileName, File fromDirectory, boolean skipNonExistentFromFile, File toDirectory, ExistingTargetStrategy existingTargetStrategy) throws IOException {
            File fromFile2 = this.fromFile(fs, fromDirectory, fileName, skipNonExistentFromFile);
            if (fromFile2 != null && this.toFile(fs, toDirectory, fileName, existingTargetStrategy) != null) {
                fs.moveToDirectory(fromFile2, toDirectory);
            }
        }
    }
    ,
    DELETE{

        @Override
        public void perform(FileSystemAbstraction fs, String fileName, File directory, boolean skipNonExistentFromFile, File unusedFile, ExistingTargetStrategy unused) throws IOException {
            File file = this.fromFile(fs, directory, fileName, skipNonExistentFromFile);
            if (file != null) {
                fs.deleteFile(file);
            }
        }
    };


    public abstract void perform(FileSystemAbstraction var1, String var2, File var3, boolean var4, File var5, ExistingTargetStrategy var6) throws IOException;

    protected File fromFile(FileSystemAbstraction fs, File directory, String name2, boolean skipNonExistent) {
        File fromFile2 = new File(directory, name2);
        if (skipNonExistent && !fs.fileExists(fromFile2)) {
            return null;
        }
        return fromFile2;
    }

    protected File toFile(FileSystemAbstraction fs, File directory, String name2, ExistingTargetStrategy existingTargetStrategy) {
        File file = new File(directory, name2);
        if (fs.fileExists(file)) {
            switch (existingTargetStrategy) {
                case FAIL: 
                case OVERWRITE: {
                    fs.deleteFile(file);
                    return file;
                }
                case SKIP: {
                    return null;
                }
            }
            throw new IllegalStateException(existingTargetStrategy.name());
        }
        return file;
    }
}

