/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.storemigration;

import java.io.File;
import java.util.HashMap;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.ArrayUtil;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.RecordStore;
import org.neo4j.kernel.impl.store.StoreFactory;
import org.neo4j.kernel.impl.store.StoreType;
import org.neo4j.kernel.impl.store.format.RecordFormats;
import org.neo4j.kernel.impl.store.id.DefaultIdGeneratorFactory;
import org.neo4j.kernel.impl.store.record.AbstractBaseRecord;
import org.neo4j.kernel.impl.storemigration.monitoring.MigrationProgressMonitor;
import org.neo4j.logging.NullLogProvider;

public class DirectRecordStoreMigrator {
    private final PageCache pageCache;
    private final FileSystemAbstraction fs;
    private final Config config;

    public DirectRecordStoreMigrator(PageCache pageCache, FileSystemAbstraction fs, Config config) {
        this.pageCache = pageCache;
        this.fs = fs;
        this.config = config;
    }

    public void migrate(File fromStoreDir, RecordFormats fromFormat, File toStoreDir, RecordFormats toFormat, MigrationProgressMonitor.Section progressMonitor, StoreType[] types2, StoreType ... additionalTypesToOpen) {
        StoreType[] storesToOpen = ArrayUtil.concat(types2, additionalTypesToOpen);
        progressMonitor.start(storesToOpen.length);
        try (NeoStores fromStores = new StoreFactory(fromStoreDir, this.config, new DefaultIdGeneratorFactory(this.fs), this.pageCache, this.fs, fromFormat, NullLogProvider.getInstance()).openNeoStores(true, storesToOpen);
             NeoStores toStores = new StoreFactory(toStoreDir, this.withPersistedStoreHeadersAsConfigFrom(fromStores, storesToOpen), new DefaultIdGeneratorFactory(this.fs), this.pageCache, this.fs, toFormat, NullLogProvider.getInstance()).openNeoStores(true, storesToOpen);){
            for (StoreType type : types2) {
                if (!type.isRecordStore()) continue;
                this.migrate(fromStores.getRecordStore(type), toStores.getRecordStore(type));
                progressMonitor.progress(1L);
            }
        }
    }

    private <RECORD extends AbstractBaseRecord> void migrate(RecordStore<RECORD> from2, RecordStore<RECORD> to2) {
        to2.setHighestPossibleIdInUse(from2.getHighestPossibleIdInUse());
        from2.scanAllRecords(record -> {
            to2.prepareForCommit(record);
            to2.updateRecord(record);
            return false;
        });
    }

    private Config withPersistedStoreHeadersAsConfigFrom(NeoStores legacyStores, StoreType[] types2) {
        HashMap<String, String> config = new HashMap<String, String>(this.config.getParams());
        if (ArrayUtil.contains(types2, StoreType.RELATIONSHIP_GROUP)) {
            config.put(GraphDatabaseSettings.dense_node_threshold.name(), String.valueOf(legacyStores.getRelationshipGroupStore().getStoreHeaderInt()));
        }
        if (ArrayUtil.contains(types2, StoreType.PROPERTY)) {
            config.put(GraphDatabaseSettings.array_block_size.name(), String.valueOf(legacyStores.getPropertyStore().getArrayStore().getRecordDataSize()));
            config.put(GraphDatabaseSettings.string_block_size.name(), String.valueOf(legacyStores.getPropertyStore().getStringStore().getRecordDataSize()));
        }
        if (ArrayUtil.contains(types2, StoreType.NODE_LABEL)) {
            config.put(GraphDatabaseSettings.label_block_size.name(), String.valueOf(legacyStores.getNodeStore().getDynamicLabelStore().getRecordDataSize()));
        }
        return new Config(config);
    }
}

