/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store.record;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Supplier;
import org.neo4j.function.Suppliers;
import org.neo4j.kernel.api.properties.DefinedProperty;
import org.neo4j.kernel.impl.store.PropertyStore;
import org.neo4j.kernel.impl.store.PropertyType;
import org.neo4j.kernel.impl.store.record.DynamicRecord;

public class PropertyBlock
implements Cloneable {
    private static final long KEY_BITMASK = 0xFFFFFFL;
    private static final int MAX_ARRAY_TOSTRING_SIZE = 4;
    private List<DynamicRecord> valueRecords;
    private long[] valueBlocks;

    public PropertyType getType() {
        return this.getType(false);
    }

    public PropertyType forceGetType() {
        return this.getType(true);
    }

    private PropertyType getType(boolean force) {
        return this.valueBlocks == null ? null : (force ? PropertyType.getPropertyTypeOrNull(this.valueBlocks[0]) : PropertyType.getPropertyTypeOrThrow(this.valueBlocks[0]));
    }

    public int getKeyIndexId() {
        return PropertyBlock.keyIndexId(this.valueBlocks[0]);
    }

    public void setKeyIndexId(int key) {
        this.valueBlocks[0] = this.valueBlocks[0] & 0xFFFFFFFFFF000000L;
        this.valueBlocks[0] = this.valueBlocks[0] | (long)key;
    }

    public void setSingleBlock(long value) {
        this.valueBlocks = new long[1];
        this.valueBlocks[0] = value;
        if (this.valueRecords != null) {
            this.valueRecords.clear();
        }
    }

    public void addValueRecord(DynamicRecord record) {
        if (this.valueRecords == null) {
            this.valueRecords = new LinkedList<DynamicRecord>();
        }
        this.valueRecords.add(record);
    }

    public void setValueRecords(List<DynamicRecord> valueRecords) {
        assert (this.valueRecords == null || this.valueRecords.isEmpty()) : this.valueRecords.toString();
        this.valueRecords = valueRecords;
    }

    public List<DynamicRecord> getValueRecords() {
        return this.valueRecords != null ? this.valueRecords : Collections.emptyList();
    }

    public long getSingleValueBlock() {
        return this.valueBlocks[0];
    }

    public long getSingleValueLong() {
        return PropertyBlock.fetchLong(this.valueBlocks[0]);
    }

    public int getSingleValueInt() {
        return PropertyBlock.fetchInt(this.valueBlocks[0]);
    }

    public short getSingleValueShort() {
        return PropertyBlock.fetchShort(this.valueBlocks[0]);
    }

    public byte getSingleValueByte() {
        return PropertyBlock.fetchByte(this.valueBlocks[0]);
    }

    public long[] getValueBlocks() {
        return this.valueBlocks;
    }

    public boolean isLight() {
        return this.valueRecords == null || this.valueRecords.isEmpty();
    }

    public void setValueBlocks(long[] blocks) {
        int expectedPayloadSize = PropertyType.getPayloadSizeLongs();
        assert (blocks == null || blocks.length <= expectedPayloadSize) : "I was given an array of size " + blocks.length + ", but I wanted it to be " + expectedPayloadSize;
        this.valueBlocks = blocks;
        if (this.valueRecords != null) {
            this.valueRecords.clear();
        }
    }

    public int getSize() {
        return this.valueBlocks == null ? 0 : this.valueBlocks.length * 8;
    }

    public String toString() {
        StringBuilder result2 = new StringBuilder("PropertyBlock[");
        PropertyType type = this.getType();
        if (this.valueBlocks != null) {
            result2.append("blocks=").append(this.valueBlocks.length).append(",");
        }
        result2.append(type == null ? "<unknown type>" : type.name()).append(',');
        result2.append("key=").append(this.valueBlocks == null ? "?" : Integer.toString(this.getKeyIndexId()));
        if (type != null) {
            switch (type) {
                case STRING: 
                case ARRAY: {
                    result2.append(",firstDynamic=").append(this.getSingleValueLong());
                    break;
                }
                default: {
                    Object value = type.getValue(this, null);
                    if (value != null && value.getClass().isArray()) {
                        int length2 = Array.getLength(value);
                        StringBuilder buf = new StringBuilder(value.getClass().getComponentType().getSimpleName()).append("[");
                        for (int i = 0; i < length2 && i <= 4; ++i) {
                            if (i != 0) {
                                buf.append(",");
                            }
                            buf.append(Array.get(value, i));
                        }
                        if (length2 > 4) {
                            buf.append(",...");
                        }
                        value = buf.append("]");
                    }
                    result2.append(",value=").append(value);
                }
            }
        }
        if (!this.isLight()) {
            result2.append(",ValueRecords[");
            Iterator<DynamicRecord> recIt = this.valueRecords.iterator();
            while (recIt.hasNext()) {
                result2.append(recIt.next());
                if (!recIt.hasNext()) continue;
                result2.append(',');
            }
            result2.append(']');
        }
        result2.append(']');
        return result2.toString();
    }

    public PropertyBlock clone() {
        PropertyBlock result2 = new PropertyBlock();
        if (this.valueBlocks != null) {
            result2.valueBlocks = (long[])this.valueBlocks.clone();
        }
        if (this.valueRecords != null) {
            for (DynamicRecord valueRecord : this.valueRecords) {
                result2.addValueRecord(valueRecord.clone());
            }
        }
        return result2;
    }

    public boolean hasSameContentsAs(PropertyBlock other2) {
        return Arrays.equals(this.valueBlocks, other2.valueBlocks);
    }

    public DefinedProperty newPropertyData(PropertyStore propertyStore) {
        return this.newPropertyData(Suppliers.singleton(propertyStore));
    }

    public DefinedProperty newPropertyData(Supplier<PropertyStore> propertyStore) {
        return this.getType().readProperty(this.getKeyIndexId(), this, propertyStore);
    }

    public static int keyIndexId(long valueBlock) {
        return (int)(valueBlock & 0xFFFFFFL);
    }

    public static long fetchLong(long valueBlock) {
        return (valueBlock & 0xFFFFFFFFF0000000L) >>> 28;
    }

    public static int fetchInt(long valueBlock) {
        return (int)((valueBlock & 0xFFFFFFFF0000000L) >>> 28);
    }

    public static short fetchShort(long valueBlock) {
        return (short)((valueBlock & 0xFFFF0000000L) >>> 28);
    }

    public static byte fetchByte(long valueBlock) {
        return (byte)((valueBlock & 0xFF0000000L) >>> 28);
    }

    public static boolean valueIsInlined(long valueBlock) {
        return (valueBlock & 0x10000000L) > 0L;
    }
}

