/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store.record;

import java.nio.ByteBuffer;
import org.neo4j.kernel.api.index.SchemaIndexProvider;
import org.neo4j.kernel.impl.store.record.AbstractSchemaRule;
import org.neo4j.kernel.impl.util.IoPrimitiveUtils;
import org.neo4j.storageengine.api.schema.IndexSchemaRule;
import org.neo4j.storageengine.api.schema.SchemaRule;
import org.neo4j.string.UTF8;

public class IndexRule
extends AbstractSchemaRule
implements IndexSchemaRule {
    private static final long NO_OWNING_CONSTRAINT = -1L;
    private final SchemaIndexProvider.Descriptor providerDescriptor;
    private final int label;
    private final int propertyKey;
    private final Long owningConstraint;

    static IndexRule readIndexRule(long id, boolean constraintIndex, int label, ByteBuffer serialized) {
        SchemaIndexProvider.Descriptor providerDescriptor = IndexRule.readProviderDescriptor(serialized);
        int propertyKeyId = IndexRule.readPropertyKey(serialized);
        if (constraintIndex) {
            long owningConstraint = IndexRule.readOwningConstraint(serialized);
            return IndexRule.constraintIndexRule(id, label, propertyKeyId, providerDescriptor, owningConstraint);
        }
        return IndexRule.indexRule(id, label, propertyKeyId, providerDescriptor);
    }

    public static IndexRule indexRule(long id, int label, int propertyKeyId, SchemaIndexProvider.Descriptor providerDescriptor) {
        return new IndexRule(id, label, propertyKeyId, providerDescriptor, null);
    }

    public static IndexRule constraintIndexRule(long id, int label, int propertyKeyId, SchemaIndexProvider.Descriptor providerDescriptor, Long owningConstraint) {
        return new IndexRule(id, label, propertyKeyId, providerDescriptor, owningConstraint == null ? -1L : owningConstraint);
    }

    public IndexRule(long id, int label, int propertyKey, SchemaIndexProvider.Descriptor providerDescriptor, Long owningConstraint) {
        super(id, IndexRule.indexKind(owningConstraint));
        this.owningConstraint = owningConstraint;
        if (providerDescriptor == null) {
            throw new IllegalArgumentException("null provider descriptor prohibited");
        }
        this.providerDescriptor = providerDescriptor;
        this.label = label;
        this.propertyKey = propertyKey;
    }

    private static SchemaRule.Kind indexKind(Long owningConstraint) {
        return owningConstraint == null ? SchemaRule.Kind.INDEX_RULE : SchemaRule.Kind.CONSTRAINT_INDEX_RULE;
    }

    private static SchemaIndexProvider.Descriptor readProviderDescriptor(ByteBuffer serialized) {
        String providerKey = UTF8.getDecodedStringFrom(serialized);
        String providerVersion = UTF8.getDecodedStringFrom(serialized);
        return new SchemaIndexProvider.Descriptor(providerKey, providerVersion);
    }

    private static int readPropertyKey(ByteBuffer serialized) {
        short count2 = serialized.getShort();
        assert (count2 == 1);
        return IoPrimitiveUtils.safeCastLongToInt(serialized.getLong());
    }

    private static long readOwningConstraint(ByteBuffer serialized) {
        return serialized.getLong();
    }

    public SchemaIndexProvider.Descriptor getProviderDescriptor() {
        return this.providerDescriptor;
    }

    @Override
    public int getPropertyKey() {
        return this.propertyKey;
    }

    @Override
    public boolean isConstraintIndex() {
        return this.owningConstraint != null;
    }

    @Override
    public Long getOwningConstraint() {
        if (!this.isConstraintIndex()) {
            throw new IllegalStateException("Can only get owner from constraint indexes.");
        }
        if (this.owningConstraint == -1L) {
            return null;
        }
        return this.owningConstraint;
    }

    @Override
    public int getLabel() {
        return this.label;
    }

    @Override
    public int getRelationshipType() {
        throw new IllegalStateException("Index rule is associated with nodes");
    }

    @Override
    public int length() {
        return 5 + UTF8.computeRequiredByteBufferSize(this.providerDescriptor.getKey()) + UTF8.computeRequiredByteBufferSize(this.providerDescriptor.getVersion()) + 2 + 8 + (this.isConstraintIndex() ? 8 : 0);
    }

    @Override
    public void serialize(ByteBuffer target) {
        target.putInt(this.label);
        target.put((byte)(this.kind.ordinal() + 1));
        UTF8.putEncodedStringInto(this.providerDescriptor.getKey(), target);
        UTF8.putEncodedStringInto(this.providerDescriptor.getVersion(), target);
        target.putShort((short)1);
        target.putLong(this.propertyKey);
        if (this.isConstraintIndex()) {
            target.putLong(this.owningConstraint);
        }
    }

    @Override
    public int hashCode() {
        return 31 * (31 * super.hashCode() + this.label) + this.propertyKey;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        IndexRule indexRule = (IndexRule)o;
        return this.label == indexRule.label && this.propertyKey == indexRule.propertyKey;
    }

    @Override
    public String toString() {
        String ownerString = "";
        if (this.owningConstraint != null) {
            ownerString = ", owner=" + (this.owningConstraint == -1L ? "<not set>" : this.owningConstraint);
        }
        return "IndexRule[id=" + this.id + ", label=" + this.label + ", kind=" + (Object)((Object)this.kind) + ", provider=" + this.providerDescriptor + ", properties=" + this.propertyKey + ownerString + "]";
    }

    public IndexRule withOwningConstraint(long constraintId) {
        if (!this.isConstraintIndex()) {
            throw new IllegalStateException(this + " is not a constraint index");
        }
        return IndexRule.constraintIndexRule(this.getId(), this.getLabel(), this.getPropertyKey(), this.getProviderDescriptor(), constraintId);
    }
}

