/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store.format;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.Service;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.store.MetaDataStore;
import org.neo4j.kernel.impl.store.format.RecordFormats;
import org.neo4j.kernel.impl.store.format.standard.StandardV2_0;
import org.neo4j.kernel.impl.store.format.standard.StandardV2_1;
import org.neo4j.kernel.impl.store.format.standard.StandardV2_2;
import org.neo4j.kernel.impl.store.format.standard.StandardV2_3;
import org.neo4j.kernel.impl.store.format.standard.StandardV3_0;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;

public class RecordFormatSelector {
    private static final RecordFormats DEFAULT_FORMAT = StandardV3_0.RECORD_FORMATS;
    private static final Iterable<RecordFormats> KNOWN_FORMATS = Arrays.asList(StandardV2_0.RECORD_FORMATS, StandardV2_1.RECORD_FORMATS, StandardV2_2.RECORD_FORMATS, StandardV2_3.RECORD_FORMATS, StandardV3_0.RECORD_FORMATS);

    private RecordFormatSelector() {
        throw new AssertionError((Object)"Not for instantiation!");
    }

    @Nonnull
    public static RecordFormats defaultFormat() {
        return DEFAULT_FORMAT;
    }

    @Nonnull
    public static RecordFormats selectForVersion(String storeVersion) {
        for (RecordFormats format2 : RecordFormatSelector.allFormats()) {
            if (!format2.storeVersion().equals(storeVersion)) continue;
            return format2;
        }
        throw new IllegalArgumentException("Unknown store version '" + storeVersion + "'");
    }

    @Nonnull
    public static RecordFormats selectForConfig(Config config, LogProvider logProvider) {
        String recordFormat = RecordFormatSelector.configuredRecordFormat(config);
        if (StringUtils.isEmpty(recordFormat)) {
            RecordFormatSelector.info(logProvider, "Record format not configured, selected default: " + RecordFormatSelector.defaultFormat());
            return RecordFormatSelector.defaultFormat();
        }
        RecordFormats format2 = RecordFormatSelector.selectSpecificFormat(recordFormat);
        RecordFormatSelector.info(logProvider, "Selected record format based on config: " + format2);
        return format2;
    }

    @Nullable
    static RecordFormats selectForStore(File storeDir, FileSystemAbstraction fs, PageCache pageCache, LogProvider logProvider) {
        File neoStoreFile = new File(storeDir, "neostore");
        if (fs.fileExists(neoStoreFile)) {
            try {
                long value = MetaDataStore.getRecord(pageCache, neoStoreFile, MetaDataStore.Position.STORE_VERSION);
                if (value != -1L) {
                    String storeVersion = MetaDataStore.versionLongToString(value);
                    for (RecordFormats format2 : RecordFormatSelector.allFormats()) {
                        if (!format2.storeVersion().equals(storeVersion)) continue;
                        RecordFormatSelector.info(logProvider, "Selected " + format2 + " record format from store " + storeDir);
                        return format2;
                    }
                }
            }
            catch (IOException e) {
                RecordFormatSelector.info(logProvider, "Unable to read store format: " + e.getMessage());
            }
        }
        return null;
    }

    @Nonnull
    public static RecordFormats selectForStoreOrConfig(Config config, File storeDir, FileSystemAbstraction fs, PageCache pageCache, LogProvider logProvider) {
        boolean storeWithFormatExists;
        RecordFormats configuredFormat = RecordFormatSelector.loadRecordFormat(RecordFormatSelector.configuredRecordFormat(config));
        boolean formatConfigured = configuredFormat != null;
        RecordFormats currentFormat = RecordFormatSelector.selectForStore(storeDir, fs, pageCache, NullLogProvider.getInstance());
        boolean bl = storeWithFormatExists = currentFormat != null;
        if (formatConfigured && storeWithFormatExists) {
            if (currentFormat.generation() == configuredFormat.generation()) {
                RecordFormatSelector.info(logProvider, "Configured format matches format in the store. Selected: " + currentFormat);
                return currentFormat;
            }
            throw new IllegalArgumentException(String.format("Configured format '%s' is different from the actual format in the store '%s'", configuredFormat, currentFormat));
        }
        if (!formatConfigured && storeWithFormatExists) {
            RecordFormatSelector.info(logProvider, "Format not configured. Selected format from the store: " + currentFormat);
            return currentFormat;
        }
        if (formatConfigured) {
            RecordFormatSelector.info(logProvider, "Selected configured format: " + configuredFormat);
            return configuredFormat;
        }
        return DEFAULT_FORMAT;
    }

    @Nonnull
    public static RecordFormats selectNewestFormat(Config config, File storeDir, FileSystemAbstraction fs, PageCache pageCache, LogProvider logProvider) {
        boolean formatConfigured = StringUtils.isNotEmpty(RecordFormatSelector.configuredRecordFormat(config));
        if (formatConfigured) {
            return RecordFormatSelector.selectForConfig(config, logProvider);
        }
        RecordFormats result2 = RecordFormatSelector.selectForStore(storeDir, fs, pageCache, logProvider);
        if (result2 == null) {
            RecordFormatSelector.info(logProvider, "Selected format '" + DEFAULT_FORMAT + "' for the new store");
            result2 = DEFAULT_FORMAT;
        } else if (result2.generation() < DEFAULT_FORMAT.generation()) {
            RecordFormatSelector.info(logProvider, "Selected format '" + DEFAULT_FORMAT + "' for existing store with format '" + result2 + "'");
            result2 = DEFAULT_FORMAT;
        }
        return result2;
    }

    private static Iterable<RecordFormats> allFormats() {
        Iterable<RecordFormats.Factory> loadableFormatFactories = Service.load(RecordFormats.Factory.class);
        Iterable<RecordFormats> loadableFormats = Iterables.map(RecordFormats.Factory::newInstance, loadableFormatFactories);
        return Iterables.concat(KNOWN_FORMATS, loadableFormats);
    }

    @Nonnull
    private static RecordFormats selectSpecificFormat(String recordFormat) {
        RecordFormats formats = RecordFormatSelector.loadRecordFormat(recordFormat);
        if (formats == null) {
            throw new IllegalArgumentException("No record format found with the name '" + recordFormat + "'.");
        }
        return formats;
    }

    @Nullable
    private static RecordFormats loadRecordFormat(String recordFormat) {
        if (StringUtils.isNotEmpty(recordFormat)) {
            if ("standard".equals(recordFormat)) {
                return StandardV3_0.RECORD_FORMATS;
            }
            RecordFormats.Factory formatFactory = Service.loadSilently(RecordFormats.Factory.class, recordFormat);
            if (formatFactory != null) {
                return formatFactory.newInstance();
            }
        }
        return null;
    }

    private static void info(LogProvider logProvider, String message) {
        logProvider.getLog(RecordFormatSelector.class).info(message);
    }

    @Nonnull
    private static String configuredRecordFormat(Config config) {
        return config.get(GraphDatabaseSettings.record_format);
    }
}

