/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store.format;

import java.util.Map;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.store.format.RecordFormats;

public class RecordFormatPropertyConfigurator {
    private final RecordFormats recordFormats;
    private final Config config;

    public RecordFormatPropertyConfigurator(RecordFormats recordFormats, Config config) {
        this.recordFormats = recordFormats;
        this.config = config;
    }

    private static void configureIntegerSetting(Config config, Setting<Integer> setting, int fullBlockSize, int headerSize, Map<String, String> formatConfig) {
        int updatedBlockSize;
        Integer defaultValue = Integer.parseInt(setting.getDefaultValue());
        int propertyValue = config.get(setting);
        if (propertyValue == defaultValue && (updatedBlockSize = fullBlockSize - headerSize) != propertyValue) {
            if (updatedBlockSize < 16) {
                throw new IllegalArgumentException("Block size should be bigger then 16");
            }
            RecordFormatPropertyConfigurator.addFormatSetting(formatConfig, setting, updatedBlockSize);
        }
    }

    private static void addFormatSetting(Map<String, String> configMap, Setting setting, int value) {
        configMap.put(setting.name(), String.valueOf(value));
    }

    public void configure() {
        Map<String, String> formatConfig = MapUtil.stringMap(new String[0]);
        int headerSize = this.recordFormats.dynamic().getRecordHeaderSize();
        RecordFormatPropertyConfigurator.configureIntegerSetting(this.config, GraphDatabaseSettings.string_block_size, 128, headerSize, formatConfig);
        RecordFormatPropertyConfigurator.configureIntegerSetting(this.config, GraphDatabaseSettings.array_block_size, 128, headerSize, formatConfig);
        RecordFormatPropertyConfigurator.configureIntegerSetting(this.config, GraphDatabaseSettings.label_block_size, 64, headerSize, formatConfig);
        if (!formatConfig.isEmpty()) {
            this.config.augment(formatConfig);
        }
    }
}

