/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store.counts.keys;

import org.neo4j.kernel.impl.api.CountsVisitor;
import org.neo4j.kernel.impl.store.counts.keys.CountsKey;
import org.neo4j.kernel.impl.store.counts.keys.CountsKeyType;
import org.neo4j.kernel.impl.util.IdPrettyPrinter;

public final class NodeKey
implements CountsKey {
    private final int labelId;

    NodeKey(int labelId) {
        this.labelId = labelId;
    }

    public int getLabelId() {
        return this.labelId;
    }

    public String toString() {
        return String.format("NodeKey[(%s)]", IdPrettyPrinter.label(this.labelId));
    }

    @Override
    public void accept(CountsVisitor visitor, long ignored, long count2) {
        visitor.visitNodeCount(this.labelId, count2);
    }

    @Override
    public CountsKeyType recordType() {
        return CountsKeyType.ENTITY_NODE;
    }

    public int hashCode() {
        int result2 = this.labelId;
        result2 = 31 * result2 + this.recordType().hashCode();
        return result2;
    }

    public boolean equals(Object o) {
        return this == o || o instanceof NodeKey && this.labelId == ((NodeKey)o).labelId;
    }

    @Override
    public int compareTo(CountsKey other2) {
        if (other2 instanceof NodeKey) {
            NodeKey that = (NodeKey)other2;
            return this.labelId - that.labelId;
        }
        return this.recordType().ordinal() - other2.recordType().ordinal();
    }
}

