/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store.counts.keys;

import org.neo4j.kernel.impl.store.counts.keys.CountsKey;
import org.neo4j.kernel.impl.store.counts.keys.CountsKeyType;
import org.neo4j.kernel.impl.util.IdPrettyPrinter;

abstract class IndexKey
implements CountsKey {
    private final int labelId;
    private final int propertyKeyId;
    private final CountsKeyType type;

    IndexKey(int labelId, int propertyKeyId, CountsKeyType type) {
        this.labelId = labelId;
        this.propertyKeyId = propertyKeyId;
        this.type = type;
    }

    public int labelId() {
        return this.labelId;
    }

    public int propertyKeyId() {
        return this.propertyKeyId;
    }

    public String toString() {
        return String.format("IndexKey[%s (%s {%s})]", this.type.name(), IdPrettyPrinter.label(this.labelId), IdPrettyPrinter.propertyKey(this.propertyKeyId));
    }

    @Override
    public CountsKeyType recordType() {
        return this.type;
    }

    public int hashCode() {
        int result2 = this.labelId;
        result2 = 31 * result2 + this.propertyKeyId;
        result2 = 31 * result2 + this.type.hashCode();
        return result2;
    }

    public boolean equals(Object other2) {
        if (this == other2) {
            return true;
        }
        if (other2 == null || this.getClass() != other2.getClass()) {
            return false;
        }
        IndexKey indexKey = (IndexKey)other2;
        return this.labelId == indexKey.labelId && this.propertyKeyId == indexKey.propertyKeyId && this.type == indexKey.type;
    }
}

