/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.security.SecureRandom;
import java.util.Random;
import org.neo4j.kernel.impl.store.MetaDataStore;
import org.neo4j.kernel.impl.store.format.standard.StandardV3_0;

public final class StoreId
implements Externalizable {
    public static final long CURRENT_STORE_VERSION = MetaDataStore.versionStringToLong(StandardV3_0.STORE_VERSION);
    public static final StoreId DEFAULT = new StoreId(-1L, -1L, -1L, -1L, -1L);
    private static final Random r = new SecureRandom();
    private long creationTime;
    private long randomId;
    private long storeVersion;
    private long upgradeTime;
    private long upgradeId;

    private StoreId() {
    }

    public StoreId(long storeVersion) {
        long currentTimeMillis = System.currentTimeMillis();
        long randomLong = r.nextLong();
        this.storeVersion = storeVersion;
        this.creationTime = currentTimeMillis;
        this.randomId = randomLong;
        this.upgradeTime = currentTimeMillis;
        this.upgradeId = randomLong;
    }

    public StoreId(long creationTime, long randomId, long storeVersion, long upgradeTime, long upgradeId) {
        this.creationTime = creationTime;
        this.randomId = randomId;
        this.storeVersion = storeVersion;
        this.upgradeTime = upgradeTime;
        this.upgradeId = upgradeId;
    }

    public static StoreId from(ObjectInput in2) throws IOException, ClassNotFoundException {
        StoreId storeId = new StoreId();
        storeId.readExternal(in2);
        return storeId;
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public long getRandomId() {
        return this.randomId;
    }

    public long getUpgradeTime() {
        return this.upgradeTime;
    }

    public long getUpgradeId() {
        return this.upgradeId;
    }

    public long getStoreVersion() {
        return this.storeVersion;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeLong(this.creationTime);
        out.writeLong(this.randomId);
        out.writeLong(this.storeVersion);
        out.writeLong(this.upgradeTime);
        out.writeLong(this.upgradeId);
    }

    @Override
    public void readExternal(ObjectInput in2) throws IOException, ClassNotFoundException {
        this.creationTime = in2.readLong();
        this.randomId = in2.readLong();
        this.storeVersion = in2.readLong();
        this.upgradeTime = in2.readLong();
        this.upgradeId = in2.readLong();
    }

    public boolean equalsByUpgradeId(StoreId other2) {
        return StoreId.equal(this.upgradeTime, other2.upgradeTime) && StoreId.equal(this.upgradeId, other2.upgradeId);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StoreId other2 = (StoreId)o;
        return StoreId.equal(this.creationTime, other2.creationTime) && StoreId.equal(this.randomId, other2.randomId);
    }

    public int hashCode() {
        return 31 * (int)(this.creationTime ^ this.creationTime >>> 32) + (int)(this.randomId ^ this.randomId >>> 32);
    }

    public String toString() {
        return "StoreId{creationTime=" + this.creationTime + ", randomId=" + this.randomId + ", storeVersion=" + this.storeVersion + ", upgradeTime=" + this.upgradeTime + ", upgradeId=" + this.upgradeId + '}';
    }

    private static boolean equal(long first, long second) {
        return first == second || first == -1L || second == -1L;
    }
}

