/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store;

import java.io.File;
import java.util.Collection;
import java.util.Iterator;
import java.util.function.Predicate;
import org.neo4j.graphdb.ResourceIterable;
import org.neo4j.helpers.collection.Visitor;
import org.neo4j.helpers.progress.ProgressListener;
import org.neo4j.kernel.impl.store.InvalidRecordException;
import org.neo4j.kernel.impl.store.RecordCursor;
import org.neo4j.kernel.impl.store.Scanner;
import org.neo4j.kernel.impl.store.id.IdSequence;
import org.neo4j.kernel.impl.store.id.IdType;
import org.neo4j.kernel.impl.store.record.AbstractBaseRecord;
import org.neo4j.kernel.impl.store.record.DynamicRecord;
import org.neo4j.kernel.impl.store.record.LabelTokenRecord;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.PropertyKeyTokenRecord;
import org.neo4j.kernel.impl.store.record.PropertyRecord;
import org.neo4j.kernel.impl.store.record.RecordLoad;
import org.neo4j.kernel.impl.store.record.RelationshipGroupRecord;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.kernel.impl.store.record.RelationshipTypeTokenRecord;

public interface RecordStore<RECORD extends AbstractBaseRecord>
extends IdSequence {
    public static final Predicate<AbstractBaseRecord> IN_USE = AbstractBaseRecord::inUse;

    public File getStorageFileName();

    public long getHighId();

    public long getHighestPossibleIdInUse();

    public void setHighestPossibleIdInUse(long var1);

    public RECORD newRecord();

    public RECORD getRecord(long var1, RECORD var3, RecordLoad var4) throws InvalidRecordException;

    public void ensureHeavy(RECORD var1);

    public Collection<RECORD> getRecords(long var1, RecordLoad var3) throws InvalidRecordException;

    public RecordCursor<RECORD> newRecordCursor(RECORD var1);

    public long getNextRecordReference(RECORD var1);

    public void updateRecord(RECORD var1);

    public <FAILURE extends Exception> void accept(Processor<FAILURE> var1, RECORD var2) throws FAILURE;

    public int getRecordSize();

    @Deprecated
    public int getRecordDataSize();

    public int getRecordsPerPage();

    public void close();

    public void flush();

    public int getNumberOfReservedLowIds();

    public int getStoreHeaderInt();

    public void prepareForCommit(RECORD var1);

    public <EXCEPTION extends Exception> void scanAllRecords(Visitor<RECORD, EXCEPTION> var1) throws EXCEPTION;

    public static <R extends AbstractBaseRecord> R getRecord(RecordStore<R> store, long id, RecordLoad mode) {
        R record = store.newRecord();
        store.getRecord(id, record, mode);
        return record;
    }

    public static <R extends AbstractBaseRecord> R getRecord(RecordStore<R> store, long id) {
        return RecordStore.getRecord(store, id, RecordLoad.NORMAL);
    }

    public static abstract class Processor<FAILURE extends Exception> {
        private volatile boolean shouldStop;

        public void stop() {
            this.shouldStop = true;
        }

        public abstract void processSchema(RecordStore<DynamicRecord> var1, DynamicRecord var2) throws FAILURE;

        public abstract void processNode(RecordStore<NodeRecord> var1, NodeRecord var2) throws FAILURE;

        public abstract void processRelationship(RecordStore<RelationshipRecord> var1, RelationshipRecord var2) throws FAILURE;

        public abstract void processProperty(RecordStore<PropertyRecord> var1, PropertyRecord var2) throws FAILURE;

        public abstract void processString(RecordStore<DynamicRecord> var1, DynamicRecord var2, IdType var3) throws FAILURE;

        public abstract void processArray(RecordStore<DynamicRecord> var1, DynamicRecord var2) throws FAILURE;

        public abstract void processLabelArrayWithOwner(RecordStore<DynamicRecord> var1, DynamicRecord var2) throws FAILURE;

        public abstract void processRelationshipTypeToken(RecordStore<RelationshipTypeTokenRecord> var1, RelationshipTypeTokenRecord var2) throws FAILURE;

        public abstract void processPropertyKeyToken(RecordStore<PropertyKeyTokenRecord> var1, PropertyKeyTokenRecord var2) throws FAILURE;

        public abstract void processLabelToken(RecordStore<LabelTokenRecord> var1, LabelTokenRecord var2) throws FAILURE;

        public abstract void processRelationshipGroup(RecordStore<RelationshipGroupRecord> var1, RelationshipGroupRecord var2) throws FAILURE;

        protected <R extends AbstractBaseRecord> R getRecord(RecordStore<R> store, long id, R into) {
            store.getRecord(id, into, RecordLoad.FORCE);
            return into;
        }

        public <R extends AbstractBaseRecord> void applyFiltered(RecordStore<R> store, Predicate<? super R> ... filters) throws FAILURE {
            this.apply(store, ProgressListener.NONE, filters);
        }

        public <R extends AbstractBaseRecord> void applyFiltered(RecordStore<R> store, ProgressListener progressListener, Predicate<? super R> ... filters) throws FAILURE {
            this.apply(store, progressListener, filters);
        }

        private <R extends AbstractBaseRecord> void apply(RecordStore<R> store, ProgressListener progressListener, Predicate<? super R> ... filters) throws FAILURE {
            ResourceIterable<R> iterable = Scanner.scan(store, true, filters);
            try (Iterator scan2 = iterable.iterator();){
                while (scan2.hasNext()) {
                    AbstractBaseRecord record = (AbstractBaseRecord)scan2.next();
                    if (this.shouldStop) break;
                    store.accept(this, record);
                    progressListener.set(record.getId());
                }
                progressListener.done();
            }
        }
    }

    public static class Delegator<R extends AbstractBaseRecord>
    implements RecordStore<R> {
        private final RecordStore<R> actual;

        @Override
        public void setHighestPossibleIdInUse(long highestIdInUse) {
            this.actual.setHighestPossibleIdInUse(highestIdInUse);
        }

        @Override
        public R newRecord() {
            return this.actual.newRecord();
        }

        @Override
        public R getRecord(long id, R target, RecordLoad mode) throws InvalidRecordException {
            return this.actual.getRecord(id, target, mode);
        }

        @Override
        public Collection<R> getRecords(long firstId, RecordLoad mode) throws InvalidRecordException {
            return this.actual.getRecords(firstId, mode);
        }

        @Override
        public RecordCursor<R> newRecordCursor(R record) {
            return this.actual.newRecordCursor(record);
        }

        @Override
        public long getNextRecordReference(R record) {
            return this.actual.getNextRecordReference(record);
        }

        public Delegator(RecordStore<R> actual2) {
            this.actual = actual2;
        }

        @Override
        public long nextId() {
            return this.actual.nextId();
        }

        @Override
        public File getStorageFileName() {
            return this.actual.getStorageFileName();
        }

        @Override
        public long getHighId() {
            return this.actual.getHighId();
        }

        @Override
        public long getHighestPossibleIdInUse() {
            return this.actual.getHighestPossibleIdInUse();
        }

        @Override
        public void updateRecord(R record) {
            this.actual.updateRecord(record);
        }

        @Override
        public <FAILURE extends Exception> void accept(Processor<FAILURE> processor, R record) throws FAILURE {
            this.actual.accept(processor, record);
        }

        @Override
        public int getRecordSize() {
            return this.actual.getRecordSize();
        }

        @Override
        public int getRecordDataSize() {
            return this.actual.getRecordDataSize();
        }

        @Override
        public int getRecordsPerPage() {
            return this.actual.getRecordsPerPage();
        }

        @Override
        public int getStoreHeaderInt() {
            return this.actual.getStoreHeaderInt();
        }

        @Override
        public void close() {
            this.actual.close();
        }

        @Override
        public int getNumberOfReservedLowIds() {
            return this.actual.getNumberOfReservedLowIds();
        }

        @Override
        public void flush() {
            this.actual.flush();
        }

        @Override
        public void ensureHeavy(R record) {
            this.actual.ensureHeavy(record);
        }

        @Override
        public void prepareForCommit(R record) {
            this.actual.prepareForCommit(record);
        }

        @Override
        public <EXCEPTION extends Exception> void scanAllRecords(Visitor<R, EXCEPTION> visitor) throws EXCEPTION {
            this.actual.scanAllRecords(visitor);
        }
    }
}

