/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store;

import java.util.Arrays;

public class LabelIdArray {
    static long[] concatAndSort(long[] existing, long additional) {
        LabelIdArray.assertNotContains(existing, additional);
        long[] result2 = new long[existing.length + 1];
        System.arraycopy(existing, 0, result2, 0, existing.length);
        result2[existing.length] = additional;
        Arrays.sort(result2);
        return result2;
    }

    private static void assertNotContains(long[] existingLabels, long labelId) {
        if (Arrays.binarySearch(existingLabels, labelId) >= 0) {
            throw new IllegalStateException("Label " + labelId + " already exists.");
        }
    }

    static long[] filter(long[] ids2, long excludeId) {
        boolean found = false;
        for (int i = 0; i < ids2.length; ++i) {
            if (ids2[i] != excludeId) continue;
            found = true;
            break;
        }
        if (!found) {
            throw new IllegalStateException("Label " + excludeId + " not found.");
        }
        long[] result2 = new long[ids2.length - 1];
        int writerIndex = 0;
        for (int i = 0; i < ids2.length; ++i) {
            if (ids2[i] == excludeId) continue;
            result2[writerIndex++] = ids2[i];
        }
        return result2;
    }

    public static long[] prependNodeId(long nodeId, long[] labelIds) {
        long[] result2 = new long[labelIds.length + 1];
        System.arraycopy(labelIds, 0, result2, 1, labelIds.length);
        result2[0] = nodeId;
        return result2;
    }

    public static long[] stripNodeId(long[] storedLongs) {
        return Arrays.copyOfRange(storedLongs, 1, storedLongs.length);
    }
}

